;;; -*- Log: C.Log -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;;
(ext:file-comment
  "$Header: src/code/exports.lisp $")
;;;
;;; **********************************************************************
;;;
;;; All the stuff necessary to export various symbols from various packages.
;;;

(in-package "LISP")

(intl:textdomain "cmucl")

(if (find-package "PCL")
    (rename-package "PCL" "PCL" 'nil)
    (make-package "PCL" :nicknames 'nil :use nil))
(if (find-package "CLOS-MOP")
    (rename-package "CLOS-MOP" "CLOS-MOP" 'nil)
    (make-package "CLOS-MOP" :nicknames 'nil :use nil))
(if (find-package "C-CALL")
    (rename-package "C-CALL" "C-CALL" 'nil)
    (make-package "C-CALL" :nicknames 'nil :use nil))
(if (find-package "INSPECT")
    (rename-package "INSPECT" "INSPECT" 'nil)
    (make-package "INSPECT" :nicknames 'nil :use nil))
(if (find-package "BIGNUM")
    (rename-package "BIGNUM" "BIGNUM" 'nil)
    (make-package "BIGNUM" :nicknames 'nil :use nil))
(if (find-package "UNIX")
    (rename-package "UNIX" "UNIX" 'nil)
    (make-package "UNIX" :nicknames 'nil :use nil))
(if (find-package "FORMAT")
    (rename-package "FORMAT" "FORMAT" 'nil)
    (make-package "FORMAT" :nicknames 'nil :use nil))
(if (find-package "LISP")
    (rename-package "LISP" "LISP")
    (make-package "LISP" :nicknames 'nil :use nil))
(if (find-package "COMMON-LISP")
    (rename-package "COMMON-LISP" "COMMON-LISP" '("CL"))
    (make-package "COMMON-LISP" :nicknames '("CL") :use nil))
(if (find-package "EVAL")
    (rename-package "EVAL" "EVAL" 'nil)
    (make-package "EVAL" :nicknames 'nil :use nil))
#+pmax
(if (find-package "PMAX")
    (rename-package "PMAX" "PMAX" '("VM"))
    (make-package "PMAX" :nicknames '("VM") :use nil))
#+sparc
(if (find-package "SPARC")
    (rename-package "SPARC" "SPARC" '("VM"))
    (make-package "SPARC" :nicknames '("VM") :use nil))
#+ibmrt
(if (find-package "RT")
    (rename-package "RT" "RT" '("VM"))
    (make-package "RT" :nicknames '("VM") :use nil))
#+x86
(if (find-package "X86")
    (rename-package "X86" "X86" '("VM"))
    (make-package "X86" :nicknames '("VM") :use nil))
#+amd64
(if (find-package "AMD64")
    (rename-package "AMD64" "AMD64" '("VM"))
    (make-package "AMD64" :nicknames '("VM") :use nil))
#+hppa
(if (find-package "HPPA")
    (rename-package "HPPA" "HPPA" '("VM"))
    (make-package "HPPA" :nicknames '("VM") :use nil))
#+alpha
(if (find-package "ALPHA")
    (rename-package "ALPHA" "ALPHA" '("VM"))
    (make-package "ALPHA" :nicknames '("VM") :use nil))
#+sgi
(if (find-package "SGI")
    (rename-package "SGI" "SGI" '("VM"))
    (make-package "SGI" :nicknames '("VM") :use nil))
#+ppc
(if (find-package "PPC")
    (rename-package "PPC" "PPC" '("VM"))
    (make-package "PPC" :nicknames '("VM")))
(if (find-package "CONDITIONS")
    (rename-package "CONDITIONS" "CONDITIONS" 'nil)
    (make-package "CONDITIONS" :nicknames 'nil :use nil))
(if (find-package "DISASSEM")
    (rename-package "DISASSEM" "DISASSEM" 'nil)
    (make-package "DISASSEM" :nicknames 'nil :use nil))
(if (find-package "DEBUG")
    (rename-package "DEBUG" "DEBUG" 'nil)
    (make-package "DEBUG" :nicknames 'nil :use nil))
(if (find-package "EXTENSIONS")
    (rename-package "EXTENSIONS" "EXTENSIONS" '("EXT"))
    (make-package "EXTENSIONS" :nicknames '("EXT") :use nil))
(if (find-package "DEBUG-INTERNALS")
    (rename-package "DEBUG-INTERNALS" "DEBUG-INTERNALS" '("DI"))
    (make-package "DEBUG-INTERNALS" :nicknames '("DI") :use nil))
(if (find-package "C")
    (rename-package "C" "C" '("OLD-C"))
    (make-package "C" :nicknames '("OLD-C") :use nil))
(if (find-package "XREF")
    (rename-package "XREF" "XREF" 'nil))
(if (find-package "WIRE")
    (rename-package "WIRE" "WIRE" 'nil)
    (make-package "WIRE" :nicknames 'nil :use nil))
(if (find-package "PRETTY-PRINT")
    (rename-package "PRETTY-PRINT" "PRETTY-PRINT" '("PP"))
    (make-package "PRETTY-PRINT" :nicknames '("PP") :use nil))
(if (find-package "SYSTEM")
    (rename-package "SYSTEM" "SYSTEM" '("SYS"))
    (make-package "SYSTEM" :nicknames '("SYS") :use nil))
(if (find-package "ALIEN")
    (rename-package "ALIEN" "ALIEN" 'nil)
    (make-package "ALIEN" :nicknames 'nil :use nil))
(if (find-package "ALIEN-INTERNALS")
    (rename-package "ALIEN-INTERNALS" "ALIEN-INTERNALS" 'nil)
    (make-package "ALIEN-INTERNALS" :nicknames 'nil :use nil))
(if (find-package "PROFILE")
    (rename-package "PROFILE" "PROFILE" 'nil)
    (make-package "PROFILE" :nicknames 'nil :use nil))
(if (find-package "COMMON-LISP-USER")
    (rename-package "COMMON-LISP-USER" "COMMON-LISP-USER" '("CL-USER"))
    (make-package "COMMON-LISP-USER" :nicknames '("CL-USER") :use nil))
(if (find-package "KERNEL")
    (rename-package "KERNEL" "KERNEL" 'nil)
    (make-package "KERNEL" :nicknames 'nil :use nil))
(if (find-package "NEW-ASSEM")
    (rename-package "NEW-ASSEM" "NEW-ASSEM" 'nil)
    (make-package "NEW-ASSEM" :nicknames 'nil :use nil))
(if (find-package "MULTIPROCESSING")
    (rename-package "MULTIPROCESSING" "MULTIPROCESSING" 'nil)
    (make-package "MULTIPROCESSING" :nicknames '("MP") :use nil))

(use-package '("SYSTEM" "ALIEN-INTERNALS" "ALIEN" "LISP") "C-CALL")
(use-package '("KERNEL" "EXTENSIONS" "LISP") "INSPECT")
(use-package '("LISP" "KERNEL") "BIGNUM")
(use-package '("LISP") "UNIX")
(use-package '("KERNEL" "LISP" "EXTENSIONS") "FORMAT")
(use-package '("EXTENSIONS" "SYSTEM" "DEBUG" "KERNEL" "BIGNUM") "LISP")
(use-package '("LISP" "KERNEL") "EVAL")
(use-package
 '("C-CALL" "ALIEN-INTERNALS" "ALIEN" "BIGNUM" "LISP" "KERNEL" "EXTENSIONS"
   "SYSTEM" "C")
 "VM")
(use-package '("EXTENSIONS" "LISP") "CONDITIONS")
(use-package '("LISP") "DISASSEM")
(use-package '("EXTENSIONS" "LISP" "SYSTEM") "DEBUG")
(use-package '("C-CALL" "ALIEN" "COMMON-LISP" "SYSTEM") "EXTENSIONS")
(use-package '("LISP" "SYSTEM" "EXTENSIONS" "KERNEL") "DEBUG-INTERNALS")
(use-package
 '("ALIEN-INTERNALS" "ALIEN" "COMMON-LISP" "EXTENSIONS" "KERNEL"
   "SYSTEM" "BIGNUM")
 "C")
(use-package '("LISP") "WIRE")
(use-package '("KERNEL" "EXTENSIONS" "LISP") "PRETTY-PRINT")
(use-package '("EXTENSIONS" "LISP") "SYSTEM")
(use-package '("SYSTEM" "EXTENSIONS" "LISP") "ALIEN")
(use-package '("LISP") "ALIEN-INTERNALS")
(use-package '("COMMON-LISP") "PROFILE")
(use-package '("EXTENSIONS" "COMMON-LISP") "COMMON-LISP-USER")
(use-package '("ALIEN-INTERNALS" "LISP" "EXTENSIONS" "SYSTEM" "BIGNUM")
             "KERNEL")
(use-package '("LISP") "NEW-ASSEM")

(defpackage "ANSI-LOOP")

(defpackage "C-CALL"
  (:import-from "COMMON-LISP" "CHAR" "FLOAT")
  (:export "C-STRING" "CHAR" "DOUBLE" "FLOAT" "INT" "LONG" "SHORT"
           "SIGNED-CHAR"
	   "UNSIGNED-CHAR" "UNSIGNED-INT" "UNSIGNED-LONG" "UNSIGNED-SHORT"
	   "LONG-LONG" "UNSIGNED-LONG-LONG"
	   "VOID"))

(defpackage "INSPECT"
  (:export "*INTERFACE-STYLE*" "REMOVE-ALL-DISPLAYS"
	   "REMOVE-OBJECT-DISPLAY" "SHOW-OBJECT"))

(defpackage "BIGNUM"
  (:export "%ADD-WITH-CARRY" "%ALLOCATE-BIGNUM" "%ASHL" "%ASHR"
	   "%BIGNUM-LENGTH" "%BIGNUM-REF" "%BIGNUM-SET" "%BIGNUM-SET-LENGTH"
	   "%DIGIT-0-OR-PLUSP" "%DIGIT-LOGICAL-SHIFT-RIGHT"
	   "%FIXNUM-DIGIT-WITH-CORRECT-SIGN" "%FIXNUM-TO-DIGIT" "%FLOOR"
	   "%LOGAND" "%LOGIOR" "%LOGNOT" "%LOGXOR" "%MULTIPLY"
	   "%MULTIPLY-AND-ADD" "%SUBTRACT-WITH-BORROW" "ADD-BIGNUMS"
	   "BIGNUM-ASHIFT-LEFT" "BIGNUM-ASHIFT-RIGHT" "BIGNUM-COMPARE"
	   "BIGNUM-DEPOSIT-BYTE" "BIGNUM-ELEMENT-TYPE" "BIGNUM-GCD"
	   "BIGNUM-INDEX" "BIGNUM-INTEGER-LENGTH" "BIGNUM-LOAD-BYTE"
	   "BIGNUM-LOGBITP" "BIGNUM-LOGCOUNT"
	   "BIGNUM-LOGICAL-AND" "BIGNUM-LOGICAL-IOR"
	   "BIGNUM-LOGICAL-NOT" "BIGNUM-LOGICAL-XOR" "BIGNUM-PLUS-P"
	   "BIGNUM-TO-FLOAT" "BIGNUM-TRUNCATE" "BIGNUM-TYPE"
	   "FLOAT-BIGNUM-RATIO" "MAKE-SMALL-BIGNUM"
	   "MULTIPLY-BIGNUM-AND-FIXNUM" "MULTIPLY-BIGNUMS" "MULTIPLY-FIXNUMS"
	   "NEGATE-BIGNUM" "SUBTRACT-BIGNUM"))

(defpackage "UNIX"
  (:export "UNIX-CURRENT-DIRECTORY"
	   "UNIX-OPEN"
	   "UNIX-READ"
	   "UNIX-WRITE"
	   "UNIX-GETPAGESIZE"
	   "UNIX-ERRNO"
	   "UNIX-MAYBE-PREPEND-CURRENT-DIRECTORY"
	   "UNIX-RESOLVE-LINKS"
	   "UNIX-SIMPLIFY-PATHNAME"
	   "UNIX-CLOSE"
	   "UNIX-STAT"
	   "UNIX-LSTAT"
	   "UNIX-FSTAT"
	   "UNIX-GETHOSTNAME"
	   "UNIX-LSEEK"
	   "UNIX-EXIT"
	   "UNIX-CHDIR"
	   "UNIX-ACCESS"
	   "UNIX-DUP"
	   "UNIX-CHMOD"
	   "UNIX-READLINK"
	   "UNIX-RENAME"
	   "UNIX-SELECT"
	   "UNIX-FAST-GETRUSAGE"
	   "UNIX-GETRUSAGE"
	   "UNIX-GETTIMEOFDAY"
	   "UNIX-ISATTY"
	   "UNIX-MKDIR"
	   "UNIX-RMDIR"
	   "UNIX-UNLINK"
	   "TIMEZONE"
	   "TIMEVAL"
	   "SIZE-T"
	   "OFF-T"
	   "INO-T"
	   "DEV-T"
	   "TIME-T"
	   "USER-INFO-NAME"
	   "INT64-T"
	   "MODE-T"
	   "UNIX-FAST-SELECT"
	   "UNIX-PIPE"
	   "UNIX-GETPID"
	   "UNIX-GETHOSTID"
	   "UNIX-UID"
	   "UNIX-GID"
	   "GET-UNIX-ERROR-MSG"
	   "WINSIZE"
	   "TIMEVAL"
	   "CLOSE-DIR"
	   "OPEN-DIR"
	   "READ-DIR"

	   ;; filesys.lisp
	   "UNIX-GETPWUID"

	   ;; multi-proc.lisp
	   "UNIX-SETITIMER"

	   ;; run-program.lisp
	   "UNIX-TTYNAME"
	   "UNIX-IOCTL"
	   "UNIX-OPENPTY"

	   ;; alien-callback.lisp
	   "UNIX-MPROTECT"

	   ;; internet.lisp
	   "UNIX-SOCKET"
	   "UNIX-CONNECT"
	   "UNIX-BIND"
	   "UNIX-LISTEN"
	   "UNIX-ACCEPT"
	   "UNIX-GETSOCKOPT"
	   "UNIX-SETSOCKOPT"
	   "UNIX-GETPEERNAME"
	   "UNIX-GETSOCKNAME"
	   "UNIX-RECV"
	   "UNIX-SEND"
	   "UNIX-RECVFROM"
	   "UNIX-SENDTO"
	   "UNIX-SHUTDOWN"
	   "UNIX-FCNTL"

	   ;; serve-event.lisp
	   "FD-SETSIZE"
	   "FD-ISSET"
	   "FD-CLR"

	   ;; Simple streams
	   "PROT_READ"
	   "UNIX-MMAP"
	   "UNIX-MUNMAP"
	   "UNIX-MSYNC"

	   ;; Motif
	   "UNIX-GETUID"

	   ;; Hemlock
	   "UNIX-CFGETOSPEED"
	   "TERMIOS"
	   "UNIX-TCGETATTR"
	   "UNIX-TCSETATTR"
	   "UNIX-FCHMOD"
	   "UNIX-CREAT"
	   "UNIX-UTIMES"

	   ;; Tests
	   "UNIX-SYMLINK"

	   ;; Other symbols from structures, etc.
	   "C-CC" "C-CFLAG" "C-IFLAG" "C-ISPEED" "C-LFLAG" "C-OFLAG" "C-OSPEED"
	   "CHECK" "D-NAME" "D-RECLEN" "E2BIG" "EACCES" "EADDRINUSE" "EADDRNOTAVAIL"
	   "EAFNOSUPPORT" "EAGAIN" "EALREADY" "EBADF" "EBUSY" "ECHILD"
	   "ECONNABORTED" "ECONNREFUSED" "ECONNRESET" "EDEADLK" "EDESTADDRREQ"
	   "EDOM" "EDQUOT" "EEXIST" "EFAULT" "EFBIG" "EHOSTDOWN" "EHOSTUNREACH"
	   "EINPROGRESS" "EINTR" "EINVAL" "EIO" "EISCONN" "EISDIR" "ELOOP" "EMFILE"
	   "EMLINK" "EMSGSIZE" "ENAMETOOLONG" "ENETDOWN" "ENETRESET" "ENETUNREACH"
	   "ENFILE" "ENOBUFS" "ENODEV" "ENOENT" "ENOEXEC" "ENOMEM" "ENOPROTOOPT"
	   "ENOSPC" "ENOTBLK" "ENOTCONN" "ENOTDIR" "ENOTEMPTY" "ENOTSOCK" "ENOTTY"
	   "ENXIO" "EOPNOTSUPP" "EPERM" "EPFNOSUPPORT" "EPIPE" "EPROTONOSUPPORT"
	   "EPROTOTYPE" "ERANGE" "EREMOTE" "EROFS" "ESHUTDOWN" "ESOCKTNOSUPPORT"
	   "ESPIPE" "ESRCH" "ESUCCESS" "ETIMEDOUT" "ETOOMANYREFS" "ETXTBSY" "EUSERS"
	   "EWOULDBLOCK" "EXDEV" "F-GETFL" "F-GETOWN" "F-SETFL" "F-SETOWN" "FAPPEND"
	   "FASYNC" "FD-SET" "FD-ZERO" "FNDELAY" "F_OK" "GID-T" "IT-INTERVAL"
	   "IT-VALUE" "ITIMERVAL" "L_INCR" "L_SET" "L_XTND" "MAP_ANONYMOUS"
	   "MAP_FIXED" "MAP_PRIVATE" "MAP_SHARED" "MS_ASYNC" "MS_INVALIDATE"
	   "MS_SYNC" "O_APPEND" "O_CREAT" "O_EXCL" "O_NDELAY" "O_NONBLOCK"
	   "O_RDONLY" "O_RDWR" "O_TRUNC" "O_WRONLY" "PROT_EXEC" "PROT_NONE"
	   "PROT_WRITE" "RU-IDRSS" "RU-INBLOCK" "RU-ISRSS" "RU-IXRSS" "RU-MAJFLT"
	   "RU-MAXRSS" "RU-MINFLT" "RU-MSGRCV" "RU-MSGSND" "RU-NIVCSW" "RU-NSIGNALS"
	   "RU-NSWAP" "RU-NVCSW" "RU-OUBLOCK" "RU-STIME" "RU-UTIME"
	   "RUSAGE_CHILDREN" "RUSAGE_SELF" "R_OK" "S-IFBLK" "S-IFCHR" "S-IFDIR"
	   "S-IFLNK" "S-IFMT" "S-IFREG" "S-IFSOCK" "SIGABRT" "SIGALRM" "SIGBUS"
	   "SIGCHLD" "SIGCONT" "SIGCONTEXT" "SIGFPE" "SIGHUP" "SIGILL" "SIGINT"
	   "SIGIO" "SIGIOT" "SIGKILL" "SIGMASK" "SIGPIPE" "SIGPROF" "SIGQUIT"
	   "SIGSEGV" "SIGSTOP" "SIGTERM" "SIGTRAP" "SIGTSTP" "SIGTTIN" "SIGTTOU"
	   "SIGURG" "SIGUSR1" "SIGUSR2" "SIGVTALRM" "SIGWINCH" "SIGXCPU" "SIGXFSZ"
	   "ST-ATIME" "ST-BLKSIZE" "ST-BLOCKS" "ST-CTIME" "ST-DEV" "ST-GID"
	   "ST-MODE" "ST-MTIME" "ST-NLINK" "ST-RDEV" "ST-SIZE" "ST-UID" "STAT"
	   "TCSADRAIN" "TCSAFLUSH" "TCSANOW" "TIOCGPGRP" "TIOCGWINSZ" "TIOCNOTTY"
	   "TIOCSPGRP" "TIOCSWINSZ" "TTY-BRKINT" "TTY-ECHO" "TTY-ECHOCTL"
	   "TTY-ECHOE" "TTY-ECHOK" "TTY-ECHOKE" "TTY-ECHONL" "TTY-ECHOPRT"
	   "TTY-FLUSHO" "TTY-ICANON" "TTY-ICRNL" "TTY-IEXTEN" "TTY-IGNBRK"
	   "TTY-IGNCR" "TTY-IGNPAR" "TTY-IMAXBEL" "TTY-INLCR" "TTY-INPCK" "TTY-ISIG"
	   "TTY-ISTRIP" "TTY-IXANY" "TTY-IXOFF" "TTY-IXON" "TTY-NOFLSH" "TTY-ONLCR"
	   "TTY-OPOST" "TTY-PARMRK" "TTY-PENDIN" "TTY-TOSTOP" "TV-SEC" "TV-USEC"
	   "TZ-DSTTIME" "TZ-MINUTESWEST" "UID-T" "UNIX-FD" "UNIX-FILE-KIND"
	   "UNIX-FILE-MODE" "UNIX-GETUID" "UNIX-KILL" "UNIX-KILLPG" "UNIX-PATHNAME"
	   "UNIX-SIGBLOCK" "UNIX-SIGNAL-DESCRIPTION" "UNIX-SIGNAL-NAME"
	   "UNIX-SIGNAL-NUMBER" "UNIX-SIGPAUSE" "UNIX-SIGSETMASK" "USER-INFO"
	   "USER-INFO-DIR" "USER-INFO-GECOS" "USER-INFO-GID" "USER-INFO-PASSWORD"
	   "USER-INFO-SHELL" "USER-INFO-UID" "VDSUSP" "VEOF" "VEOL" "VEOL2" "VERASE"
	   "VINTR" "VKILL" "VMIN" "VQUIT" "VSTART" "VSTOP" "VSUSP" "VTIME"
	   "WRITEOWN" "WS-COL" "WS-ROW" "WS-XPIXEL" "WS-YPIXEL" "W_OK" "X_OK"
	   "FIONREAD"
	   "TERMINAL-SPEEDS"
	   )
  (:export
   ;; For asdf
   "UNIX-GETENV"
   "UNIX-SETENV"
   "UNIX-PUTENV"
   "UNIX-UNSETENV"
   ;; For slime
   "UNIX-EXECVE"
   "UNIX-FORK")
  #-(or linux solaris)
  (:export "TCHARS"
	   "LTCHARS"
	   "D-NAMLEN"

	   
	   ;; run-program.lisp
	   "SGTTYB"

	   ;; Other symbols from structures, etc.
	   "DIRECT" "ELOCAL" "EPROCLIM" "EVICEERR" "EVICEOP" "EXECGRP" "EXECOTH"
	   "EXECOWN" "F-DUPFD" "F-GETFD" "F-SETFD" "FCREAT" "FEXCL"
	   "FTRUNC" "READGRP" "READOTH" "READOWN" "S-IEXEC" "S-IREAD" "S-ISGID"
	   "S-ISUID" "S-ISVTX" "S-IWRITE" "SAVETEXT" "SETGIDEXEC" "SETUIDEXEC"
	   "SG-ERASE" "SG-FLAGS" "SG-ISPEED" "SG-KILL" "SG-OSPEED" "SIGEMT" "SIGSYS"
	   "T-BRKC" "T-DSUSPC" "T-EOFC" "T-FLUSHC" "T-INTRC" "T-LNEXTC" "T-QUITC"
	   "T-RPRNTC" "T-STARTC" "T-STOPC" "T-SUSPC" "T-WERASC" "TCIFLUSH"
	   "TCIOFLUSH" "TCOFLUSH" "TIOCFLUSH" "TIOCGETC"
	   "TIOCGETP" "TIOCGLTC" "TIOCSETC" "TIOCSETP" "TIOCSLTC" "TTY-CBREAK"
	   "TTY-CLOCAL" "TTY-CREAD" "TTY-CRMOD" "TTY-CS5" "TTY-CS6" "TTY-CS7"
	   "TTY-CS8" "TTY-CSIZE" "TTY-CSTOPB" "TTY-HUPCL" "TTY-LCASE" "TTY-PARENB"
	   "TTY-PARODD" "TTY-RAW" "TTY-TANDEM" "WRITEGRP" "WRITEOTH"
	   )
  #+linux
  (:export "TCHARS"
	   "LTCHARS"
	   "D-NAMLEN"

	   ;; run-program.lisp
	   "SGTTYB"

	   ;; Other symbols
	   "BLKCNT-T" "D-INO" "D-OFF" "EADV" "EBADE" "EBADFD" "EBADMSG" "EBADR"
	   "EBADRQC" "EBADSLT" "EBFONT" "ECHRNG" "ECOMM" "EDEADLOCK" "EDOTDOT"
	   "EIDRM" "EILSEQ" "EISNAM" "EL2HLT" "EL2NSYNC" "EL3HLT" "EL3RST" "ELIBACC"
	   "ELIBBAD" "ELIBEXEC" "ELIBMAX" "ELIBSCN" "ELNRNG" "EMULTIHOP" "ENAVAIL"
	   "ENOANO" "ENOCSI" "ENODATA" "ENOLCK" "ENOLINK" "ENOMSG" "ENONET" "ENOPKG"
	   "ENOSR" "ENOSTR" "ENOSYS" "ENOTNAM" "ENOTUNIQ" "EOVERFLOW" "EPROTO"
	   "EREMCHG" "EREMOTEIO" "ERESTART" "ESRMNT" "ESTALE" "ESTRPIPE" "ETIME"
	   "EUCLEAN" "EUNATCH" "EXFULL" "O_NOCTTY" "SIGSTKFLT"
	   "SG-FLAGS"
	   "TIOCGETP"
	   "TIOCSETP"
	   "TTY-IUCLC"
	   "TTY-OCRNL" "TTY-OFDEL" "TTY-OFILL" "TTY-OLCUC" "TTY-ONLRET" "TTY-ONOCR"
	   "TTY-XCASE" "UNIX-DUP2" "UNIX-GETITIMER" "UNIX-PID"
	   "UTSNAME"
	   )
  #+solaris
  (:export "D-INO"
	   "D-OFF"
	   "DIRECT"
	   "EADV"
	   "EBADE"
	   "EBADFD"
	   "EBADMSG"
	   "EBADR"
	   "EBADRQC"
	   "EBADSLT"
	   "EBFONT"
	   "ECANCELED"
	   "ECHRNG"
	   "ECOMM"
	   "EDEADLOCK"
	   "EIDRM"
	   "EILSEQ"
	   "EL2HLT"
	   "EL2NSYNC"
	   "EL3HLT"
	   "EL3RST"
	   "ELIBACC"
	   "ELIBBAD"
	   "ELIBEXEC"
	   "ELIBMAX"
	   "ELIBSCN"
	   "ELNRNG"
	   "EMULTIHOP"
	   "ENOANO"
	   "ENOCSI"
	   "ENODATA"
	   "ENOLCK"
	   "ENOLINK"
	   "ENOMSG"
	   "ENONET"
	   "ENOPKG"
	   "ENOSR"
	   "ENOSTR"
	   "ENOSYS"
	   "ENOTSUP"
	   "ENOTUNIQ"
	   "EOVERFLOW"
	   "EPROTO"
	   "EREMCHG"
	   "ERESTART"
	   "ESRMNT"
	   "ESTALE"
	   "ESTRPIPE"
	   "ETIME"
	   "EUNATCH"
	   "EXECGRP"
	   "EXECOTH"
	   "EXECOWN"
	   "EXFULL"
	   "F-DUPFD"
	   "F-GETFD"
	   "F-SETFD"
	   "FCREAT"
	   "FEXCL"
	   "FTRUNC"
	   "LTCHARS"
	   "O_NOCTTY"
	   "RCV1EN"
	   "READGRP"
	   "READOTH"
	   "READOWN"
	   "S-IEXEC"
	   "S-IREAD"
	   "S-ISGID"
	   "S-ISUID"
	   "S-ISVTX"
	   "S-IWRITE"
	   "SAVETEXT"
	   "SETGIDEXEC"
	   "SETUIDEXEC"
	   "SG-ERASE"
	   "SG-FLAGS"
	   "SG-ISPEED"
	   "SG-KILL"
	   "SG-OSPEED"
	   "SGTTYB"
	   "SIGEMT"
	   "SIGSYS"
	   "SIGWAITING"
	   "T-BRKC"
	   "T-DSUSPC"
	   "T-EOFC"
	   "T-FLUSHC"
	   "T-INTRC"
	   "T-LNEXTC"
	   "T-QUITC"
	   "T-RPRNTC"
	   "T-STARTC"
	   "T-STOPC"
	   "T-SUSPC"
	   "T-WERASC"
	   "TCHARS"
	   "TCIFLUSH"
	   "TCIOFLUSH"
	   "TCOFLUSH"
	   "TIOCFLUSH"
	   "TIOCGETC"
	   "TIOCGETP"
	   "TIOCGLTC"
	   "TIOCSETC"
	   "TIOCSETP"
	   "TIOCSLTC"
	   "TTY-CBAUD"
	   "TTY-CBREAK"
	   "TTY-CLOCAL"
	   "TTY-CREAD"
	   "TTY-CRMOD"
	   "TTY-CS5"
	   "TTY-CS6"
	   "TTY-CS7"
	   "TTY-CS8"
	   "TTY-CSIZE"
	   "TTY-CSTOPB"
	   "TTY-DEFECHO"
	   "TTY-HUPCL"
	   "TTY-IUCLC"
	   "TTY-LCASE"
	   "TTY-LOBLK"
	   "TTY-OCRNL"
	   "TTY-OFDEL"
	   "TTY-OFILL"
	   "TTY-OLCUC"
	   "TTY-ONLRET"
	   "TTY-ONOCR"
	   "TTY-PARENB"
	   "TTY-PARODD"
	   "TTY-RAW"
	   "TTY-TANDEM"
	   "TTY-XCASE"
	   "UNIX-TIMES"
	   "UTSNAME"
	   "WRITEGRP"
	   "WRITEOTH"
	   "XMT1EN"
	   ))
  
(defpackage "FORMAT")

(defpackage "COMMON-LISP"
  (:nicknames "CL")
  ;;
  ;; It might be nicer if these symbols were from CL, but it's not
  ;; required, and moving them from EXT probably requires additional
  ;; magic, so I didn't do it. -- 2003-06-16, gerd.
  (:import-from "EXTENSIONS" "DEBUG" "FLOATING-POINT-INEXACT")
  (:export
   "&ALLOW-OTHER-KEYS" "&AUX" "&BODY" "&ENVIRONMENT" "&KEY" "&OPTIONAL" "&REST"
   "&WHOLE" "*" "**" "***" "*BREAK-ON-SIGNALS*" "*COMPILE-FILE-PATHNAME*"
   "*COMPILE-FILE-TRUENAME*" "*COMPILE-PRINT*" "*COMPILE-VERBOSE*" "*DEBUG-IO*"
   "*DEBUGGER-HOOK*" "*DEFAULT-PATHNAME-DEFAULTS*" "*ERROR-OUTPUT*" "*FEATURES*"
   "*GENSYM-COUNTER*" "*LOAD-PATHNAME*" "*LOAD-PRINT*" "*LOAD-TRUENAME*"
   "*LOAD-VERBOSE*" "*MACROEXPAND-HOOK*" "*MODULES*" "*PACKAGE*" "*PRINT-ARRAY*"
   "*PRINT-BASE*" "*PRINT-CASE*" "*PRINT-CIRCLE*" "*PRINT-ESCAPE*"
   "*PRINT-GENSYM*" "*PRINT-LENGTH*" "*PRINT-LEVEL*" "*PRINT-LINES*"
   "*PRINT-MISER-WIDTH*" "*PRINT-PPRINT-DISPATCH*" "*PRINT-PRETTY*"
   "*PRINT-RADIX*" "*PRINT-READABLY*" "*PRINT-RIGHT-MARGIN*" "*QUERY-IO*"
   "*RANDOM-STATE*" "*READ-BASE*" "*READ-DEFAULT-FLOAT-FORMAT*" "*READ-EVAL*"
   "*READ-SUPPRESS*" "*READTABLE*" "*STANDARD-INPUT*" "*STANDARD-OUTPUT*"
   "*TERMINAL-IO*" "*TRACE-OUTPUT*" "+" "++" "+++" "-" "/" "//" "///" "/=" "1+"
   "1-" "<" "<=" "=" ">" ">=" "ABORT" "ABS" "ACONS" "ACOS" "ACOSH" "ADD-METHOD"
   "ADJOIN" "ADJUST-ARRAY" "ADJUSTABLE-ARRAY-P" "ALLOCATE-INSTANCE"
   "ALPHA-CHAR-P" "ALPHANUMERICP" "AND" "APPEND" "APPLY" "APROPOS" "APROPOS-LIST"
   "AREF" "ARITHMETIC-ERROR" "ARITHMETIC-ERROR-OPERANDS"
   "ARITHMETIC-ERROR-OPERATION" "ARRAY" "ARRAY-DIMENSION" "ARRAY-DIMENSION-LIMIT"
   "ARRAY-DIMENSIONS" "ARRAY-DISPLACEMENT" "ARRAY-ELEMENT-TYPE"
   "ARRAY-HAS-FILL-POINTER-P" "ARRAY-IN-BOUNDS-P" "ARRAY-RANK" "ARRAY-RANK-LIMIT"
   "ARRAY-ROW-MAJOR-INDEX" "ARRAY-TOTAL-SIZE" "ARRAY-TOTAL-SIZE-LIMIT" "ARRAYP"
   "ASH" "ASIN" "ASINH" "ASSERT" "ASSOC" "ASSOC-IF" "ASSOC-IF-NOT" "ATAN" "ATANH"
   "ATOM" "BASE-CHAR" "BASE-STRING" "BIGNUM" "BIT" "BIT-AND" "BIT-ANDC1"
   "BIT-ANDC2" "BIT-EQV" "BIT-IOR" "BIT-NAND" "BIT-NOR" "BIT-NOT" "BIT-ORC1"
   "BIT-ORC2" "BIT-VECTOR" "BIT-VECTOR-P" "BIT-XOR" "BLOCK" "BOOLE" "BOOLE-1"
   "BOOLE-2" "BOOLE-AND" "BOOLE-ANDC1" "BOOLE-ANDC2" "BOOLE-C1" "BOOLE-C2"
   "BOOLE-CLR" "BOOLE-EQV" "BOOLE-IOR" "BOOLE-NAND" "BOOLE-NOR" "BOOLE-ORC1"
   "BOOLE-ORC2" "BOOLE-SET" "BOOLE-XOR" "BOOLEAN" "BOTH-CASE-P" "BOUNDP" "BREAK"
   "BROADCAST-STREAM" "BROADCAST-STREAM-STREAMS" "BUILT-IN-CLASS" "BUTLAST"
   "BYTE" "BYTE-POSITION" "BYTE-SIZE" "CAAAAR" "CAAADR" "CAAAR" "CAADAR" "CAADDR"
   "CAADR" "CAAR" "CADAAR" "CADADR" "CADAR" "CADDAR" "CADDDR" "CADDR" "CADR"
   "CALL-ARGUMENTS-LIMIT" "CALL-METHOD" "CALL-NEXT-METHOD" "CAR" "CASE" "CATCH"
   "CCASE" "CDAAAR" "CDAADR" "CDAAR" "CDADAR" "CDADDR" "CDADR" "CDAR" "CDDAAR"
   "CDDADR" "CDDAR" "CDDDAR" "CDDDDR" "CDDDR" "CDDR" "CDR" "CEILING" "CELL-ERROR"
   "CELL-ERROR-NAME" "CERROR" "CHANGE-CLASS" "CHAR" "CHAR-CODE" "CHAR-CODE-LIMIT"
   "CHAR-DOWNCASE" "CHAR-EQUAL" "CHAR-GREATERP" "CHAR-INT" "CHAR-LESSP"
   "CHAR-NAME" "CHAR-NOT-EQUAL" "CHAR-NOT-GREATERP" "CHAR-NOT-LESSP"
   "CHAR-UPCASE" "CHAR/=" "CHAR<" "CHAR<=" "CHAR=" "CHAR>" "CHAR>=" "CHARACTER"
   "CHARACTERP" "CHECK-TYPE" "CIS" "CLASS" "CLASS-NAME" "CLASS-OF" "CLEAR-INPUT"
   "CLEAR-OUTPUT" "CLOSE" "CLRHASH" "CODE-CHAR" "COERCE" "COMPILATION-SPEED"
   "COMPILE" "COMPILE-FILE" "COMPILE-FILE-PATHNAME" "COMPILED-FUNCTION"
   "COMPILED-FUNCTION-P" "COMPILER-MACRO" "COMPILER-MACRO-FUNCTION" "COMPLEMENT"
   "COMPLEX" "COMPLEXP" "COMPUTE-APPLICABLE-METHODS" "COMPUTE-RESTARTS"
   "CONCATENATE" "CONCATENATED-STREAM" "CONCATENATED-STREAM-STREAMS" "COND"
   "CONDITION" "CONJUGATE" "CONS" "CONSP" "CONSTANTLY" "CONSTANTP" "CONTINUE"
   "CONTROL-ERROR" "COPY-ALIST" "COPY-LIST" "COPY-PPRINT-DISPATCH"
   "COPY-READTABLE" "COPY-SEQ" "COPY-STRUCTURE" "COPY-SYMBOL" "COPY-TREE" "COS"
   "COSH" "COUNT" "COUNT-IF" "COUNT-IF-NOT" "CTYPECASE" "DEBUG" "DECF" "DECLAIM"
   "DECLARATION" "DECLARE" "DECODE-FLOAT" "DECODE-UNIVERSAL-TIME" "DEFCLASS"
   "DEFCONSTANT" "DEFGENERIC" "DEFINE-COMPILER-MACRO" "DEFINE-CONDITION"
   "DEFINE-METHOD-COMBINATION" "DEFINE-MODIFY-MACRO" "DEFINE-SETF-EXPANDER"
   "DEFINE-SYMBOL-MACRO" "DEFMACRO" "DEFMETHOD" "DEFPACKAGE" "DEFPARAMETER"
   "DEFSETF" "DEFSTRUCT" "DEFTYPE" "DEFUN" "DEFVAR" "DELETE" "DELETE-DUPLICATES"
   "DELETE-FILE" "DELETE-IF" "DELETE-IF-NOT" "DELETE-PACKAGE" "DENOMINATOR"
   "DEPOSIT-FIELD" "DESCRIBE" "DESCRIBE-OBJECT" "DESTRUCTURING-BIND" "DIGIT-CHAR"
   "DIGIT-CHAR-P" "DIRECTORY" "DIRECTORY-NAMESTRING" "DISASSEMBLE"
   "DIVISION-BY-ZERO" "DO" "DO*" "DO-ALL-SYMBOLS" "DO-EXTERNAL-SYMBOLS"
   "DO-SYMBOLS" "DOCUMENTATION" "DOLIST" "DOTIMES" "DOUBLE-FLOAT"
   "DOUBLE-FLOAT-EPSILON" "DOUBLE-FLOAT-NEGATIVE-EPSILON" "DPB" "DRIBBLE"
   "DYNAMIC-EXTENT" "ECASE" "ECHO-STREAM" "ECHO-STREAM-INPUT-STREAM"
   "ECHO-STREAM-OUTPUT-STREAM" "ED" "EIGHTH" "ELT" "ENCODE-UNIVERSAL-TIME"
   "END-OF-FILE" "ENDP" "ENOUGH-NAMESTRING" "ENSURE-DIRECTORIES-EXIST"
   "ENSURE-GENERIC-FUNCTION" "EQ" "EQL" "EQUAL" "EQUALP" "ERROR" "ETYPECASE"
   "EVAL" "EVAL-WHEN" "EVENP" "EVERY" "EXP" "EXPORT" "EXPT" "EXTENDED-CHAR"
   "FBOUNDP" "FCEILING" "FDEFINITION" "FFLOOR" "FIFTH" "FILE-AUTHOR" "FILE-ERROR"
   "FILE-ERROR-PATHNAME" "FILE-LENGTH" "FILE-NAMESTRING" "FILE-POSITION"
   "FILE-STREAM" "FILE-STRING-LENGTH" "FILE-WRITE-DATE" "FILL" "FILL-POINTER"
   "FIND" "FIND-ALL-SYMBOLS" "FIND-CLASS" "FIND-IF" "FIND-IF-NOT" "FIND-METHOD"
   "FIND-PACKAGE" "FIND-RESTART" "FIND-SYMBOL" "FINISH-OUTPUT" "FIRST" "FIXNUM"
   "FLET" "FLOAT" "FLOAT-DIGITS" "FLOAT-PRECISION" "FLOAT-RADIX" "FLOAT-SIGN"
   "FLOATING-POINT-INEXACT" "FLOATING-POINT-INVALID-OPERATION"
   "FLOATING-POINT-OVERFLOW" "FLOATING-POINT-UNDERFLOW" "FLOATP" "FLOOR"
   "FMAKUNBOUND" "FORCE-OUTPUT" "FORMAT" "FORMATTER" "FOURTH" "FRESH-LINE"
   "FROUND" "FTRUNCATE" "FTYPE" "FUNCALL" "FUNCTION" "FUNCTION-KEYWORDS"
   "FUNCTION-LAMBDA-EXPRESSION" "FUNCTIONP" "GCD" "GENERIC-FUNCTION" "GENSYM"
   "GENTEMP" "GET" "GET-DECODED-TIME" "GET-DISPATCH-MACRO-CHARACTER"
   "GET-INTERNAL-REAL-TIME" "GET-INTERNAL-RUN-TIME" "GET-MACRO-CHARACTER"
   "GET-OUTPUT-STREAM-STRING" "GET-PROPERTIES" "GET-SETF-EXPANSION"
   "GET-UNIVERSAL-TIME" "GETF" "GETHASH" "GO" "GRAPHIC-CHAR-P" "HANDLER-BIND"
   "HANDLER-CASE" "HASH-TABLE" "HASH-TABLE-COUNT" "HASH-TABLE-P"
   "HASH-TABLE-REHASH-SIZE" "HASH-TABLE-REHASH-THRESHOLD" "HASH-TABLE-SIZE"
   "HASH-TABLE-TEST" "HOST-NAMESTRING" "IDENTITY" "IF" "IGNORABLE" "IGNORE"
   "IGNORE-ERRORS" "IMAGPART" "IMPORT" "IN-PACKAGE" "INCF" "INITIALIZE-INSTANCE"
   "INLINE" "INPUT-STREAM-P" "INSPECT" "INTEGER" "INTEGER-DECODE-FLOAT"
   "INTEGER-LENGTH" "INTEGERP" "INTERACTIVE-STREAM-P" "INTERN"
   "INTERNAL-TIME-UNITS-PER-SECOND" "INTERSECTION" "INVALID-METHOD-ERROR"
   "INVOKE-DEBUGGER" "INVOKE-RESTART" "INVOKE-RESTART-INTERACTIVELY" "ISQRT"
   "KEYWORD" "KEYWORDP" "LABELS" "LAMBDA" "LAMBDA-LIST-KEYWORDS"
   "LAMBDA-PARAMETERS-LIMIT" "LAST" "LCM" "LDB" "LDB-TEST" "LDIFF"
   "LEAST-NEGATIVE-DOUBLE-FLOAT" "LEAST-NEGATIVE-LONG-FLOAT"
   "LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT"
   "LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT" "LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT"
   "LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT" "LEAST-NEGATIVE-SHORT-FLOAT"
   "LEAST-NEGATIVE-SINGLE-FLOAT" "LEAST-POSITIVE-DOUBLE-FLOAT"
   "LEAST-POSITIVE-LONG-FLOAT" "LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT"
   "LEAST-POSITIVE-NORMALIZED-LONG-FLOAT" "LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT"
   "LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT" "LEAST-POSITIVE-SHORT-FLOAT"
   "LEAST-POSITIVE-SINGLE-FLOAT" "LENGTH" "LET" "LET*" "LISP-IMPLEMENTATION-TYPE"
   "LISP-IMPLEMENTATION-VERSION" "LIST" "LIST*" "LIST-ALL-PACKAGES" "LIST-LENGTH"
   "LISTEN" "LISTP" "LOAD" "LOAD-LOGICAL-PATHNAME-TRANSLATIONS" "LOAD-TIME-VALUE"
   "LOCALLY" "LOG" "LOGAND" "LOGANDC1" "LOGANDC2" "LOGBITP" "LOGCOUNT" "LOGEQV"
   "LOGICAL-PATHNAME" "LOGICAL-PATHNAME-TRANSLATIONS" "LOGIOR" "LOGNAND" "LOGNOR"
   "LOGNOT" "LOGORC1" "LOGORC2" "LOGTEST" "LOGXOR" "LONG-FLOAT"
   "LONG-FLOAT-EPSILON" "LONG-FLOAT-NEGATIVE-EPSILON" "LONG-SITE-NAME" "LOOP"
   "LOOP-FINISH" "LOWER-CASE-P" "MACHINE-INSTANCE" "MACHINE-TYPE"
   "MACHINE-VERSION" "MACRO-FUNCTION" "MACROEXPAND" "MACROEXPAND-1" "MACROLET"
   "MAKE-ARRAY" "MAKE-BROADCAST-STREAM" "MAKE-CONCATENATED-STREAM"
   "MAKE-CONDITION" "MAKE-DISPATCH-MACRO-CHARACTER" "MAKE-ECHO-STREAM"
   "MAKE-HASH-TABLE" "MAKE-INSTANCE" "MAKE-INSTANCES-OBSOLETE" "MAKE-LIST"
   "MAKE-LOAD-FORM" "MAKE-LOAD-FORM-SAVING-SLOTS" "MAKE-METHOD" "MAKE-PACKAGE"
   "MAKE-PATHNAME" "MAKE-RANDOM-STATE" "MAKE-SEQUENCE" "MAKE-STRING"
   "MAKE-STRING-INPUT-STREAM" "MAKE-STRING-OUTPUT-STREAM" "MAKE-SYMBOL"
   "MAKE-SYNONYM-STREAM" "MAKE-TWO-WAY-STREAM" "MAKUNBOUND" "MAP" "MAP-INTO"
   "MAPC" "MAPCAN" "MAPCAR" "MAPCON" "MAPHASH" "MAPL" "MAPLIST" "MASK-FIELD"
   "MAX" "MEMBER" "MEMBER-IF" "MEMBER-IF-NOT" "MERGE" "MERGE-PATHNAMES" "METHOD"
   "METHOD-COMBINATION" "METHOD-COMBINATION-ERROR" "METHOD-QUALIFIERS" "MIN"
   "MINUSP" "MISMATCH" "MOD" "MOST-NEGATIVE-DOUBLE-FLOAT" "MOST-NEGATIVE-FIXNUM"
   "MOST-NEGATIVE-LONG-FLOAT" "MOST-NEGATIVE-SHORT-FLOAT"
   "MOST-NEGATIVE-SINGLE-FLOAT" "MOST-POSITIVE-DOUBLE-FLOAT"
   "MOST-POSITIVE-FIXNUM" "MOST-POSITIVE-LONG-FLOAT" "MOST-POSITIVE-SHORT-FLOAT"
   "MOST-POSITIVE-SINGLE-FLOAT" "MUFFLE-WARNING" "MULTIPLE-VALUE-BIND"
   "MULTIPLE-VALUE-CALL" "MULTIPLE-VALUE-LIST" "MULTIPLE-VALUE-PROG1"
   "MULTIPLE-VALUE-SETQ" "MULTIPLE-VALUES-LIMIT" "NAME-CHAR" "NAMESTRING"
   "NBUTLAST" "NCONC" "NEXT-METHOD-P" "NIL" "NINTERSECTION" "NINTH"
   "NO-APPLICABLE-METHOD" "NO-NEXT-METHOD" "NOT" "NOTANY" "NOTEVERY" "NOTINLINE"
   "NRECONC" "NREVERSE" "NSET-DIFFERENCE" "NSET-EXCLUSIVE-OR"
   "NSTRING-CAPITALIZE" "NSTRING-DOWNCASE" "NSTRING-UPCASE" "NSUBLIS" "NSUBST"
   "NSUBST-IF" "NSUBST-IF-NOT" "NSUBSTITUTE" "NSUBSTITUTE-IF"
   "NSUBSTITUTE-IF-NOT" "NTH" "NTH-VALUE" "NTHCDR" "NULL" "NUMBER" "NUMBERP"
   "NUMERATOR" "NUNION" "ODDP" "OPEN" "OPEN-STREAM-P" "OPTIMIZE" "OR" "OTHERWISE"
   "OUTPUT-STREAM-P" "PACKAGE" "PACKAGE-ERROR" "PACKAGE-ERROR-PACKAGE"
   "PACKAGE-NAME" "PACKAGE-NICKNAMES" "PACKAGE-SHADOWING-SYMBOLS"
   "PACKAGE-USE-LIST" "PACKAGE-USED-BY-LIST" "PACKAGEP" "PAIRLIS" "PARSE-ERROR"
   "PARSE-INTEGER" "PARSE-NAMESTRING" "PATHNAME" "PATHNAME-DEVICE"
   "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-MATCH-P" "PATHNAME-NAME"
   "PATHNAME-TYPE" "PATHNAME-VERSION" "PATHNAMEP" "PEEK-CHAR" "PHASE" "PI"
   "PLUSP" "POP" "POSITION" "POSITION-IF" "POSITION-IF-NOT" "PPRINT"
   "PPRINT-DISPATCH" "PPRINT-EXIT-IF-LIST-EXHAUSTED" "PPRINT-FILL"
   "PPRINT-INDENT" "PPRINT-LINEAR" "PPRINT-LOGICAL-BLOCK" "PPRINT-NEWLINE"
   "PPRINT-POP" "PPRINT-TAB" "PPRINT-TABULAR" "PRIN1" "PRIN1-TO-STRING" "PRINC"
   "PRINC-TO-STRING" "PRINT" "PRINT-NOT-READABLE" "PRINT-NOT-READABLE-OBJECT"
   "PRINT-OBJECT" "PRINT-UNREADABLE-OBJECT" "PROBE-FILE" "PROCLAIM" "PROG"
   "PROG*" "PROG1" "PROG2" "PROGN" "PROGRAM-ERROR" "PROGV" "PROVIDE" "PSETF"
   "PSETQ" "PUSH" "PUSHNEW" "QUOTE" "RANDOM" "RANDOM-STATE" "RANDOM-STATE-P"
   "RASSOC" "RASSOC-IF" "RASSOC-IF-NOT" "RATIO" "RATIONAL" "RATIONALIZE"
   "RATIONALP" "READ" "READ-BYTE" "READ-CHAR" "READ-CHAR-NO-HANG"
   "READ-DELIMITED-LIST" "READ-FROM-STRING" "READ-LINE"
   "READ-PRESERVING-WHITESPACE" "READ-SEQUENCE" "READER-ERROR" "READTABLE"
   "READTABLE-CASE" "READTABLEP" "REAL" "REALP" "REALPART" "REDUCE"
   "REINITIALIZE-INSTANCE" "REM" "REMF" "REMHASH" "REMOVE" "REMOVE-DUPLICATES"
   "REMOVE-IF" "REMOVE-IF-NOT" "REMOVE-METHOD" "REMPROP" "RENAME-FILE"
   "RENAME-PACKAGE" "REPLACE" "REQUIRE" "REST" "RESTART" "RESTART-BIND"
   "RESTART-CASE" "RESTART-NAME" "RETURN" "RETURN-FROM" "REVAPPEND" "REVERSE"
   "ROOM" "ROTATEF" "ROUND" "ROW-MAJOR-AREF" "RPLACA" "RPLACD" "SAFETY"
   "SATISFIES" "SBIT" "SCALE-FLOAT" "SCHAR" "SEARCH" "SECOND" "SEQUENCE"
   "SERIOUS-CONDITION" "SET" "SET-DIFFERENCE" "SET-DISPATCH-MACRO-CHARACTER"
   "SET-EXCLUSIVE-OR" "SET-MACRO-CHARACTER" "SET-PPRINT-DISPATCH"
   "SET-SYNTAX-FROM-CHAR" "SETF" "SETQ" "SEVENTH" "SHADOW" "SHADOWING-IMPORT"
   "SHARED-INITIALIZE" "SHIFTF" "SHORT-FLOAT" "SHORT-FLOAT-EPSILON"
   "SHORT-FLOAT-NEGATIVE-EPSILON" "SHORT-SITE-NAME" "SIGNAL" "SIGNED-BYTE"
   "SIGNUM" "SIMPLE-ARRAY" "SIMPLE-BASE-STRING" "SIMPLE-BIT-VECTOR"
   "SIMPLE-BIT-VECTOR-P" "SIMPLE-CONDITION" "SIMPLE-CONDITION-FORMAT-ARGUMENTS"
   "SIMPLE-CONDITION-FORMAT-CONTROL" "SIMPLE-ERROR" "SIMPLE-STRING"
   "SIMPLE-STRING-P" "SIMPLE-TYPE-ERROR" "SIMPLE-VECTOR" "SIMPLE-VECTOR-P"
   "SIMPLE-WARNING" "SIN" "SINGLE-FLOAT" "SINGLE-FLOAT-EPSILON"
   "SINGLE-FLOAT-NEGATIVE-EPSILON" "SINH" "SIXTH" "SLEEP" "SLOT-BOUNDP"
   "SLOT-EXISTS-P" "SLOT-MAKUNBOUND" "SLOT-MISSING" "SLOT-UNBOUND" "SLOT-VALUE"
   "SOFTWARE-TYPE" "SOFTWARE-VERSION" "SOME" "SORT" "SPACE" "SPECIAL"
   "SPECIAL-OPERATOR-P" "SPEED" "SQRT" "STABLE-SORT" "STANDARD" "STANDARD-CHAR"
   "STANDARD-CHAR-P" "STANDARD-CLASS" "STANDARD-GENERIC-FUNCTION"
   "STANDARD-METHOD" "STANDARD-OBJECT" "STEP" "STORAGE-CONDITION" "STORE-VALUE"
   "STREAM" "STREAM-ELEMENT-TYPE" "STREAM-ERROR" "STREAM-ERROR-STREAM"
   "STREAM-EXTERNAL-FORMAT" "STREAMP" "STRING" "STRING-CAPITALIZE"
   "STRING-DOWNCASE" "STRING-EQUAL" "STRING-GREATERP" "STRING-LEFT-TRIM"
   "STRING-LESSP" "STRING-NOT-EQUAL" "STRING-NOT-GREATERP" "STRING-NOT-LESSP"
   "STRING-RIGHT-TRIM" "STRING-STREAM" "STRING-TRIM" "STRING-UPCASE" "STRING/="
   "STRING<" "STRING<=" "STRING=" "STRING>" "STRING>=" "STRINGP" "STRUCTURE"
   "STRUCTURE-CLASS" "STRUCTURE-OBJECT" "STYLE-WARNING" "SUBLIS" "SUBSEQ"
   "SUBSETP" "SUBST" "SUBST-IF" "SUBST-IF-NOT" "SUBSTITUTE" "SUBSTITUTE-IF"
   "SUBSTITUTE-IF-NOT" "SUBTYPEP" "SVREF" "SXHASH" "SYMBOL" "SYMBOL-FUNCTION"
   "SYMBOL-MACROLET" "SYMBOL-NAME" "SYMBOL-PACKAGE" "SYMBOL-PLIST" "SYMBOL-VALUE"
   "SYMBOLP" "SYNONYM-STREAM" "SYNONYM-STREAM-SYMBOL" "T" "TAGBODY" "TAILP" "TAN"
   "TANH" "TENTH" "TERPRI" "THE" "THIRD" "THROW" "TIME" "TRACE"
   "TRANSLATE-LOGICAL-PATHNAME" "TRANSLATE-PATHNAME" "TREE-EQUAL" "TRUENAME"
   "TRUNCATE" "TWO-WAY-STREAM" "TWO-WAY-STREAM-INPUT-STREAM"
   "TWO-WAY-STREAM-OUTPUT-STREAM" "TYPE" "TYPE-ERROR" "TYPE-ERROR-DATUM"
   "TYPE-ERROR-EXPECTED-TYPE" "TYPE-OF" "TYPECASE" "TYPEP" "UNBOUND-SLOT"
   "UNBOUND-SLOT-INSTANCE" "UNBOUND-VARIABLE" "UNDEFINED-FUNCTION" "UNEXPORT"
   "UNINTERN" "UNION" "UNLESS" "UNREAD-CHAR" "UNSIGNED-BYTE" "UNTRACE"
   "UNUSE-PACKAGE" "UNWIND-PROTECT" "UPDATE-INSTANCE-FOR-DIFFERENT-CLASS"
   "UPDATE-INSTANCE-FOR-REDEFINED-CLASS" "UPGRADED-ARRAY-ELEMENT-TYPE"
   "UPGRADED-COMPLEX-PART-TYPE" "UPPER-CASE-P" "USE-PACKAGE" "USE-VALUE"
   "USER-HOMEDIR-PATHNAME" "VALUES" "VALUES-LIST" "VARIABLE" "VECTOR"
   "VECTOR-POP" "VECTOR-PUSH" "VECTOR-PUSH-EXTEND" "VECTORP" "WARN" "WARNING"
   "WHEN" "WILD-PATHNAME-P" "WITH-ACCESSORS" "WITH-COMPILATION-UNIT"
   "WITH-CONDITION-RESTARTS" "WITH-HASH-TABLE-ITERATOR" "WITH-INPUT-FROM-STRING"
   "WITH-OPEN-FILE" "WITH-OPEN-STREAM" "WITH-OUTPUT-TO-STRING"
   "WITH-PACKAGE-ITERATOR" "WITH-SIMPLE-RESTART" "WITH-SLOTS"
   "WITH-STANDARD-IO-SYNTAX" "WRITE" "WRITE-BYTE" "WRITE-CHAR" "WRITE-LINE"
   "WRITE-SEQUENCE" "WRITE-STRING" "WRITE-TO-STRING" "Y-OR-N-P" "YES-OR-NO-P"
   "ZEROP"))

(defpackage "INTL"
  (:use "COMMON-LISP")
  (:export "*LOCALE-DIRECTORIES*" "DGETTEXT" "DNGETTEXT"
	   "GETTEXT" "INSTALL" "NGETTEXT" "READ-TRANSLATABLE-STRING" "SETLOCALE"
	   "TEXTDOMAIN" "TRANSLATION-ENABLE" "TRANSLATION-DISABLE"
	   "WITH-TEXTDOMAIN"))

(defpackage "LISP"
  (:use "COMMON-LISP" "EXTENSIONS" "KERNEL" "SYSTEM" "DEBUG" "BIGNUM" "INTL")
  (:shadowing-import-from
   "COMMON-LISP" "CLASS" "BUILT-IN-CLASS" "STANDARD-CLASS" "STRUCTURE-CLASS"
   "CLASS-OF" "FIND-CLASS")
  (:export
   "CLASS" "BUILT-IN-CLASS" "STANDARD-CLASS"
   "STRUCTURE-CLASS" "CLASS-OF" "FIND-CLASS"
	     
   "&ALLOW-OTHER-KEYS" "&AUX" "&BODY" "&ENVIRONMENT" "&KEY"
   "&OPTIONAL" "&REST" "&WHOLE" "*" "**" "***"
   "*BREAK-ON-SIGNALS*"
   "*COMPILE-FILE-PATHNAME*" "*COMPILE-FILE-TRUENAME*"
   "*COMPILE-PRINT*" "*COMPILE-VERBOSE*" "*DEBUG-IO*"
   "*DEBUGGER-HOOK*" "*DEFAULT-PATHNAME-DEFAULTS*"
   "*ERROR-OUTPUT*"
   "*FEATURES*" "*GENSYM-COUNTER*" "*LOAD-PATHNAME*"
   "*LOAD-PRINT*" "*LOAD-TRUENAME*" "*LOAD-VERBOSE*"
   "*MACROEXPAND-HOOK*" "*MODULES*" "*PACKAGE*" "*PRINT-ARRAY*"
   "*PRINT-BASE*" "*PRINT-CASE*" "*PRINT-CIRCLE*"
   "*PRINT-ESCAPE*" "*PRINT-GENSYM*" "*PRINT-LENGTH*"
   "*PRINT-LEVEL*" "*PRINT-LINES*" "*PRINT-MISER-WIDTH*"
   "*PRINT-PPRINT-DISPATCH*" "*PRINT-PRETTY*" "*PRINT-RADIX*"
   "*PRINT-READABLY*" "*PRINT-RIGHT-MARGIN*" "*QUERY-IO*"
   "*RANDOM-STATE*" "*READ-BASE*" "*READ-DEFAULT-FLOAT-FORMAT*"
   "*READ-EVAL*" "*READ-SUPPRESS*" "*READTABLE*"
   "*STANDARD-INPUT*" "*STANDARD-OUTPUT*" "*TERMINAL-IO*"
   "*TRACE-OUTPUT*" "+" "++" "+++" "-" "/" "//" "///" "/=" "1+"
   "1-" "<" "<=" "=" ">" ">=" "ABORT" "ABS" "ACONS" "ACOS"
   "ACOSH" "ADJOIN" "ADJUST-ARRAY" "ADJUSTABLE-ARRAY-P"
   "ALPHA-CHAR-P" "ALPHANUMERICP" "AND" "APPEND" "APPLY"
   "APROPOS" "APROPOS-LIST" "AREF" "ARITHMETIC-ERROR"
   "ARITHMETIC-ERROR-OPERANDS" "ARITHMETIC-ERROR-OPERATION"
   "ARRAY" "ARRAY-DIMENSION" "ARRAY-DIMENSION-LIMIT"
   "ARRAY-DIMENSIONS" "ARRAY-DISPLACEMENT" "ARRAY-ELEMENT-TYPE"
   "ARRAY-HAS-FILL-POINTER-P" "ARRAY-IN-BOUNDS-P" "ARRAY-RANK"
   "ARRAY-RANK-LIMIT" "ARRAY-ROW-MAJOR-INDEX" "ARRAY-TOTAL-SIZE"
   "ARRAY-TOTAL-SIZE-LIMIT" "ARRAYP" "ASH" "ASIN" "ASINH"
   "ASSERT" "ASSOC" "ASSOC-IF" "ASSOC-IF-NOT" "ATAN" "ATANH"
   "ATOM" "BASE-CHAR" "BASE-STRING" "BIGNUM"
   "BIT" "BIT-AND" "BIT-ANDC1" "BIT-ANDC2" "BIT-EQV" "BIT-IOR"
   "BIT-NAND" "BIT-NOR" "BIT-NOT" "BIT-ORC1" "BIT-ORC2"
   "BIT-VECTOR" "BIT-VECTOR-P" "BIT-XOR" "BLOCK" "BOOLE" "BOOLEAN"
   "BOOLE-1" "BOOLE-2" "BOOLE-AND" "BOOLE-ANDC1" "BOOLE-ANDC2"
   "BOOLE-C1" "BOOLE-C2" "BOOLE-CLR" "BOOLE-EQV" "BOOLE-IOR"
   "BOOLE-NAND" "BOOLE-NOR" "BOOLE-ORC1" "BOOLE-ORC2" "BOOLE-SET"
   "BOOLE-XOR" "BOTH-CASE-P" "BOUNDP" "BREAK" "BREF"
   "BROADCAST-STREAM" "BROADCAST-STREAM-STREAMS" "BUFFER-COPY" "BUFFER-SAP"
   "BUTLAST" "BYTE" "BYTE-POSITION" "BYTE-SIZE"
   "CAAAAR" "CAAADR" "CAAAR" "CAADAR" "CAADDR" "CAADR" "CAAR"
   "CADAAR" "CADADR" "CADAR" "CADDAR" "CADDDR" "CADDR" "CADR"
   "CALL-ARGUMENTS-LIMIT" "CAR" "CASE"
   "CATCH" "CCASE" "CDAAAR" "CDAADR" "CDAAR" "CDADAR" "CDADDR"
   "CDADR" "CDAR" "CDDAAR" "CDDADR" "CDDAR" "CDDDAR" "CDDDDR"
   "CDDDR" "CDDR" "CDR" "CEILING" "CELL-ERROR" "CERROR" "CHAR"
   "CHAR-CODE" "CHAR-CODE-LIMIT" "CHAR-DOWNCASE"
   "CHAR-EQUAL" "CHAR-GREATERP" "CHAR-INT" "CHAR-LESSP" 
   "CHAR-NAME" "CHAR-NOT-EQUAL" "CHAR-NOT-GREATERP"
   "CHAR-NOT-LESSP" "CHAR-UPCASE" "CHAR/="
   "CHAR<" "CHAR<=" "CHAR=" "CHAR>" "CHAR>=" "CHARACTER"
   "CHARACTERP" "CHECK-TYPE" "CIS" "CLASS-NAME" 
   "CLEAR-INPUT" "CLEAR-OUTPUT"
   "CLOSE" "CLRHASH" "CODE-CHAR" "COERCE"
   "COMPILATION-SPEED" "COMPILE" "COMPILE-FILE"
   "COMPILE-FILE-PATHNAME"
   "COMPILED-FUNCTION" "COMPILED-FUNCTION-P"
   "COMPILER-MACRO" "COMPILER-MACRO-FUNCTION"
   "COMPLEMENT" "COMPLEX"
   "COMPLEXP" "COMPUTE-RESTARTS" "CONCATENATE"
   "CONCATENATED-STREAM" "CONCATENATED-STREAM-STREAMS"
   "COND" "CONDITION"
   "CONJUGATE" "CONS" "CONSP" "CONSTANTLY" "CONSTANTP" "CONTINUE"
   "CONTROL-ERROR" "COPY-ALIST" "COPY-LIST"
   "COPY-PPRINT-DISPATCH" "COPY-READTABLE" "COPY-SEQ"
   "COPY-STRUCTURE"
   "COPY-SYMBOL" "COPY-TREE" "COS" "COSH" "COUNT" "COUNT-IF"
   "COUNT-IF-NOT" "CTYPECASE" "DEBUG" "DECF" "DECLAIM"
   "DECLARATION" "DECLARE" "DECODE-FLOAT" "DECODE-UNIVERSAL-TIME"
   "DEFCONSTANT" "DEFINE-COMPILER-MACRO" "DEFINE-CONDITION"
   "DEFINE-MODIFY-MACRO" "DEFINE-SYMBOL-MACRO"
   "DEFMACRO" "DEFPACKAGE"
   "DEFPARAMETER" "DEFSETF" "DEFSTRUCT" "DEFTYPE" "DEFUN" "DEFVAR"
   "DELETE" "DELETE-DUPLICATES" "DELETE-FILE" "DELETE-IF"
   "DELETE-IF-NOT" "DELETE-PACKAGE"
   "DENOMINATOR" "DEPOSIT-FIELD" "DESCRIBE"
   "DESTRUCTURING-BIND" "DIGIT-CHAR" "DIGIT-CHAR-P" "DIRECTORY"
   "DIRECTORY-NAMESTRING" "DISASSEMBLE" "DIVISION-BY-ZERO" "DO" "DO*"
   "DO-ALL-SYMBOLS" "DO-EXTERNAL-SYMBOLS" "DO-SYMBOLS"
   "DOCUMENTATION" "DOLIST" "DOTIMES" "DOUBLE-FLOAT"
   "DOUBLE-FLOAT-EPSILON" "DOUBLE-FLOAT-NEGATIVE-EPSILON" "DPB"
   "DRIBBLE" "DYNAMIC-EXTENT"
   "ECASE" "ECHO-STREAM" "ECHO-STREAM-INPUT-STREAM"
   "ECHO-STREAM-OUTPUT-STREAM"
   "ED" "EIGHTH" "ELT" "ENCODE-UNIVERSAL-TIME"
   "END-OF-FILE" "ENDIAN-SWAP-VALUE" "ENDP" "ENOUGH-NAMESTRING"
   "ENSURE-DIRECTORIES-EXIST" "EQ" "EQL" "EQUAL"
   "EQUALP" "ERROR" "ETYPECASE" "EVAL" "EVAL-WHEN" "EVENP"
   "EVERY" "EXP" "EXPORT" "EXPT" "EXTENDED-CHAR" "FBOUNDP" "FCEILING"
   "FDEFINITION" "FFLOOR" "FIFTH" "FILE-AUTHOR" "FILE-ERROR"
   "FILE-ERROR-PATHNAME" "FILE-LENGTH" "FILE-NAMESTRING"
   "FILE-POSITION" "FILE-STREAM" "FILE-STRING-LENGTH"
   "FILE-WRITE-DATE" "FILL" "FILL-POINTER" "FIND"
   "FIND-ALL-SYMBOLS"
   "FIND-IF" "FIND-IF-NOT" "FIND-PACKAGE"
   "FIND-RESTART" "FIND-SYMBOL" "FINISH-OUTPUT" "FIRST" "FIXNUM"
   "FLET" "FLOAT" "FLOAT-DIGITS" "FLOAT-PRECISION" "FLOAT-RADIX"
   "FLOAT-SIGN"
   "FLOATING-POINT-DENORMAL-OPERAND"
   "FLOATING-POINT-INEXACT"
   "FLOATING-POINT-INVALID-OPERATION"
   "FLOATING-POINT-OVERFLOW" "FLOATING-POINT-UNDERFLOW"
   "FLOATP" "FLOOR" "FMAKUNBOUND" "FORCE-OUTPUT" "FORMAT" "FORMATTER"
   "FOURTH" "FRESH-LINE" "FROUND" "FTRUNCATE" "FTYPE" "FUNCALL"
   "FUNCTION" "FUNCTION-LAMBDA-EXPRESSION" "FUNCTIONP"
   "GCD" "GENERIC-FUNCTION" "GENSYM"
   "GENTEMP" "GET" "GET-DECODED-TIME" "GET-DISPATCH-MACRO-CHARACTER"
   "GET-INTERNAL-REAL-TIME" "GET-INTERNAL-RUN-TIME"
   "GET-MACRO-CHARACTER" "GET-OUTPUT-STREAM-STRING" "GET-PROPERTIES"
   "GET-UNIVERSAL-TIME" "GETF" "GETHASH" "GO" "GRAPHIC-CHAR-P"
   "HANDLER-BIND" "HANDLER-CASE" "HASH-TABLE" "HASH-TABLE-COUNT"
   "HASH-TABLE-P" "HASH-TABLE-REHASH-THRESHOLD"
   "HASH-TABLE-REHASH-SIZE" "HASH-TABLE-SIZE" "HASH-TABLE-TEST"
   "HOST-NAMESTRING" "IDENTITY" "IF" "IGNORABLE"
   "IGNORE" "IGNORE-ERRORS" "IMAGPART" "IMPORT" "IN-PACKAGE"
   "INTERACTIVE-STREAM-P" "INCF"
   "INLINE" "INPUT-STREAM-P" "INSPECT" "INTEGER"
   "INTEGER-DECODE-FLOAT" "INTEGER-LENGTH" "INTEGERP" "INTERN"
   "INTERNAL-TIME-UNITS-PER-SECOND" "INTERSECTION" "INVOKE-DEBUGGER"
   "INVOKE-RESTART" "INVOKE-RESTART-INTERACTIVELY" "ISQRT" "KEYWORD"
   "KEYWORDP" "LABELS" "LAMBDA" "LAMBDA-LIST-KEYWORDS"
   "LAMBDA-PARAMETERS-LIMIT" "LAST" "LCM" "LDB" "LDB-TEST" "LDIFF"
   "LEAST-NEGATIVE-DOUBLE-FLOAT" "LEAST-NEGATIVE-LONG-FLOAT"
   "LEAST-NEGATIVE-NORMALIZED-DOUBLE-FLOAT"
   "LEAST-NEGATIVE-NORMALIZED-LONG-FLOAT"
   "LEAST-NEGATIVE-NORMALIZED-SHORT-FLOAT"
   "LEAST-NEGATIVE-NORMALIZED-SINGLE-FLOAT"
   "LEAST-NEGATIVE-SHORT-FLOAT" "LEAST-NEGATIVE-SINGLE-FLOAT"
   "LEAST-POSITIVE-DOUBLE-FLOAT" "LEAST-POSITIVE-LONG-FLOAT"
   "LEAST-POSITIVE-NORMALIZED-DOUBLE-FLOAT"
   "LEAST-POSITIVE-NORMALIZED-LONG-FLOAT"
   "LEAST-POSITIVE-NORMALIZED-SHORT-FLOAT"
   "LEAST-POSITIVE-NORMALIZED-SINGLE-FLOAT"
   "LEAST-POSITIVE-SHORT-FLOAT" "LEAST-POSITIVE-SINGLE-FLOAT"
   "LENGTH" "LET" "LET*" "LISP-IMPLEMENTATION-TYPE"
   "LISP-IMPLEMENTATION-VERSION" "LIST" "LIST*" "LIST-ALL-PACKAGES"
   "LIST-LENGTH" "LISTEN" "LISTP" "LOAD"
   "LOAD-LOGICAL-PATHNAME-TRANSLATIONS" "LOAD-TIME-VALUE" "LOCALLY"
   "LOG" "LOGAND" "LOGANDC1" "LOGANDC2" "LOGBITP" "LOGCOUNT" "LOGEQV"
   "LOGICAL-PATHNAME" "LOGICAL-PATHNAME-TRANSLATIONS"
   "LOGIOR" "LOGNAND" "LOGNOR" "LOGNOT" "LOGORC1" "LOGORC2" "LOGTEST"
   "LOGXOR" "LONG-FLOAT" "LONG-FLOAT-EPSILON"
   "LONG-FLOAT-NEGATIVE-EPSILON" "LONG-SITE-NAME" "LOOP"
   "LOOP-FINISH" "LOWER-CASE-P" "MACHINE-INSTANCE" "MACHINE-TYPE"
   "MACHINE-VERSION" "MACRO-FUNCTION" "MACROEXPAND" "MACROEXPAND-1"
   "MACROLET" "MAKE-ARRAY" "MAKE-BROADCAST-STREAM"
   "MAKE-CONCATENATED-STREAM" "MAKE-CONDITION"
   "MAKE-DISPATCH-MACRO-CHARACTER" "MAKE-ECHO-STREAM"
   "MAKE-HASH-TABLE" "MAKE-LIST" "MAKE-PACKAGE" "MAKE-PATHNAME"
   "MAKE-RANDOM-STATE" "MAKE-SEQUENCE" "MAKE-STRING"
   "MAKE-STRING-INPUT-STREAM" "MAKE-STRING-OUTPUT-STREAM"
   "MAKE-SYMBOL" "MAKE-SYNONYM-STREAM" "MAKE-TWO-WAY-STREAM"
   "MAKUNBOUND" "MAP" "MAP-INTO" "MAPC" "MAPCAN" "MAPCAR" "MAPCON"
   "MAPHASH" "MAPL" "MAPLIST" "MASK-FIELD" "MAX" "MEMBER" "MEMBER-IF"
   "MEMBER-IF-NOT" "MERGE" "MERGE-PATHNAMES" "MIN" "MINUSP"
   "MISMATCH" "MOD" "MOST-NEGATIVE-DOUBLE-FLOAT"
   "MOST-NEGATIVE-FIXNUM" "MOST-NEGATIVE-LONG-FLOAT"
   "MOST-NEGATIVE-SHORT-FLOAT" "MOST-NEGATIVE-SINGLE-FLOAT"
   "MOST-POSITIVE-DOUBLE-FLOAT" "MOST-POSITIVE-FIXNUM"
   "MOST-POSITIVE-LONG-FLOAT" "MOST-POSITIVE-SHORT-FLOAT"
   "MOST-POSITIVE-SINGLE-FLOAT" "MUFFLE-WARNING"
   "MULTIPLE-VALUE-BIND" "MULTIPLE-VALUE-CALL" "MULTIPLE-VALUE-LIST"
   "MULTIPLE-VALUE-PROG1" "MULTIPLE-VALUE-SETQ"
   "MULTIPLE-VALUES-LIMIT" "NAME-CHAR" "NAMESTRING" "NBUTLAST"
   "NCONC" "NIL" "NINTERSECTION" "NINTH" "NOT" "NOTANY" "NOTEVERY"
   "NOTINLINE" "NRECONC" "NREVERSE" "NSET-DIFFERENCE"
   "NSET-EXCLUSIVE-OR" "NSTRING-CAPITALIZE" "NSTRING-DOWNCASE"
   "NSTRING-UPCASE" "NSUBLIS" "NSUBST" "NSUBST-IF" "NSUBST-IF-NOT"
   "NSUBSTITUTE" "NSUBSTITUTE-IF" "NSUBSTITUTE-IF-NOT" "NTH"
   "NTH-VALUE" "NTHCDR" "NULL" "NUMBER" "NUMBERP" "NUMERATOR"
   "NUNION" "ODDP" "OPEN" "OPEN-STREAM-P" "OPTIMIZE" "OR" "OTHERWISE"
   "OUTPUT-STREAM-P" "PACKAGE" "PACKAGE-ERROR"
   "PACKAGE-ERROR-PACKAGE" "PACKAGE-NAME" "PACKAGE-NICKNAMES"
   "PACKAGE-SHADOWING-SYMBOLS" "PACKAGE-USE-LIST"
   "PACKAGE-USED-BY-LIST" "PACKAGEP" "PAIRLIS" "PARSE-ERROR" 
   "PARSE-INTEGER" "PARSE-NAMESTRING" "PATHNAME" "PATHNAME-DEVICE"
   "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-MATCH-P"
   "PATHNAME-NAME" "PATHNAME-TYPE" "PATHNAME-VERSION" "PATHNAMEP"
   "PEEK-CHAR" "PHASE" "PI" "PLUSP" "POP" "POSITION" "POSITION-IF"
   "POSITION-IF-NOT" "PPRINT" "PPRINT-DISPATCH"
   "PPRINT-EXIT-IF-LIST-EXHAUSTED" "PPRINT-FILL" "PPRINT-INDENT"
   "PPRINT-LINEAR" "PPRINT-LOGICAL-BLOCK" "PPRINT-NEWLINE"
   "PPRINT-POP" "PPRINT-TAB" "PPRINT-TABULAR" "PRIN1"
   "PRIN1-TO-STRING" "PRINC" "PRINC-TO-STRING" "PRINT"
   "PRINT-UNREADABLE-OBJECT" "PROBE-FILE" "PROCLAIM" "PROG" "PROG*"
   "PROG1" "PROG2" "PROGN" "PROGRAM-ERROR" "PROGV" "PROVIDE" "PSETF"
   "PSETQ" "PUSH" "PUSHNEW" "QUOTE" "RANDOM" "RANDOM-STATE"
   "RANDOM-STATE-P" "RASSOC" "RASSOC-IF" "RASSOC-IF-NOT" "RATIO"
   "RATIONAL" "RATIONALIZE" "RATIONALP" "READ" "READ-BYTE"
   "READ-CHAR" "READ-CHAR-NO-HANG" "READ-DELIMITED-LIST"
   "READ-FROM-STRING" "READ-LINE" "READ-PRESERVING-WHITESPACE"
   "READ-SEQUENCE"
   "READER-ERROR" "READTABLE" "READTABLE-CASE" "READTABLEP" "REAL"
   "REALP" "REALPART" "REDUCE" "REM" "REMF" "REMHASH"
   "REMOVE" "REMOVE-DUPLICATES" "REMOVE-IF" "REMOVE-IF-NOT"
   "REMPROP" "RENAME-FILE" "RENAME-PACKAGE" "REPLACE" "REQUIRE"
   "REST" "RESTART" "RESTART-BIND" "RESTART-CASE" "RESTART-NAME"
   "RETURN" "RETURN-FROM" "REVAPPEND" "REVERSE" "ROOM" "ROTATEF"
   "ROUND" "ROW-MAJOR-AREF" "RPLACA" "RPLACD" "SAFETY"
   "SATISFIES" "SBIT" "SCALE-FLOAT" "SCHAR" "SEARCH" "SECOND"
   "SEQUENCE" "SERIOUS-CONDITION" "SET"
   "SET-DIFFERENCE" "SET-DISPATCH-MACRO-CHARACTER"
   "SET-EXCLUSIVE-OR" "SET-MACRO-CHARACTER" "SET-PPRINT-DISPATCH"
   "SET-SYNTAX-FROM-CHAR" "SETF" "SETQ" "SEVENTH" "SHADOW"
   "SHADOWING-IMPORT" "SHIFTF" "SHORT-FLOAT"
   "SHORT-FLOAT-EPSILON" "SHORT-FLOAT-NEGATIVE-EPSILON"
   "SHORT-SITE-NAME" "SIGNAL" "SIGNED-BYTE" "SIGNUM"
   "SIMPLE-ARRAY" "SIMPLE-BASE-STRING" "SIMPLE-BIT-VECTOR"
   "SIMPLE-BIT-VECTOR-P" "SIMPLE-CONDITION"
   "SIMPLE-CONDITION-FORMAT-ARGUMENTS"
   "SIMPLE-CONDITION-FORMAT-CONTROL"
   "SIMPLE-ERROR"
   "SIMPLE-STRING" "SIMPLE-STRING-P" "SIMPLE-TYPE-ERROR"
   "SIMPLE-VECTOR" "SIMPLE-VECTOR-P" "SIMPLE-WARNING" "SIN"
   "SINGLE-FLOAT" "SINGLE-FLOAT-EPSILON"
   "SINGLE-FLOAT-NEGATIVE-EPSILON" "SINH" "SIXTH" "SLEEP"
   "SOFTWARE-TYPE" "SOFTWARE-VERSION" "SOME" "SORT" "SPACE"
   "SPECIAL" "SPECIAL-OPERATOR-P" "SPEED" "SQRT" "STABLE-SORT"
   "STANDARD-CHAR" "STANDARD-CHAR-P" "STEP"
   "STORAGE-CONDITION" "STORE-VALUE" "STREAM"
   "STREAM-ELEMENT-TYPE" "STREAM-ERROR" "STREAM-ERROR-STREAM"
   "STREAM-EXTERNAL-FORMAT"
   "STREAMP" "STRING" "STRING-CAPITALIZE"
   "STRING-DOWNCASE" "STRING-EQUAL"
   "STRING-GREATERP" "STRING-LEFT-TRIM" "STRING-LESSP"
   "STRING-NOT-EQUAL" "STRING-NOT-GREATERP" "STRING-NOT-LESSP"
   "STRING-RIGHT-TRIM" "STRING-STREAM"
   "STRING-TRIM" "STRING-UPCASE" "STRING/="
   "STRING<" "STRING<=" "STRING=" "STRING>" "STRING>=" "STRINGP"
   "STRUCTURE" "STRUCTURE-OBJECT"
   "SUBLIS" "SUBSEQ" "SUBSETP" "SUBST" "SUBST-IF"
   "SUBST-IF-NOT" "SUBSTITUTE" "SUBSTITUTE-IF"
   "SUBSTITUTE-IF-NOT" "SUBTYPEP" "SVREF" "SXHASH" "SYMBOL"
   "SYMBOL-FUNCTION" "SYMBOL-MACROLET" "SYMBOL-NAME"
   "SYMBOL-PACKAGE" "SYMBOL-PLIST" "SYMBOL-VALUE" "SYMBOLP"
   "SYNONYM-STREAM" "SYNONYM-STREAM-SYMBOL" "T"
   "TAGBODY" "TAILP" "TAN" "TANH" "TENTH" "TERPRI" "THE" "THIRD"
   "THROW" "TIME" "TRACE" "TRANSLATE-LOGICAL-PATHNAME"
   "TRANSLATE-PATHNAME" "TREE-EQUAL"
   "TRUENAME" "TRUNCATE" "TWO-WAY-STREAM"
   "TWO-WAY-STREAM-INPUT-STREAM" "TWO-WAY-STREAM-OUTPUT-STREAM"
   "TYPE" "TYPE-ERROR" "TYPE-ERROR-DATUM"
   "TYPE-ERROR-EXPECTED-TYPE" "TYPE-OF" "TYPECASE" "TYPEP"
   "UNBOUND-VARIABLE" "UNDEFINED-FUNCTION" "UNEXPORT" "UNINTERN"
   "UNION" "UNLESS" "UNREAD-CHAR" "UNSIGNED-BYTE" "UNTRACE"
   "UNUSE-PACKAGE" "UNWIND-PROTECT" "UPGRADED-ARRAY-ELEMENT-TYPE"
   "UPGRADED-COMPLEX-PART-TYPE" "UPPER-CASE-P"
   "USE-PACKAGE" "USE-VALUE" "USER-HOMEDIR-PATHNAME" "VALUES"
   "VALUES-LIST" "VARIABLE" "VECTOR" "VECTOR-ELT-WIDTH" "VECTOR-POP" "VECTOR-PUSH"
   "VECTOR-PUSH-EXTEND" "VECTORP" "WARN" "WARNING" "WHEN"
   "WILD-PATHNAME-P" "WITH-COMPILATION-UNIT"
   "WITH-CONDITION-RESTARTS"
   "WITH-HASH-TABLE-ITERATOR" "WITH-INPUT-FROM-STRING"
   "WITH-OPEN-FILE" "WITH-OPEN-STREAM" "WITH-OUTPUT-TO-STRING"
   "WITH-PACKAGE-ITERATOR" "WITH-SIMPLE-RESTART"
   "WITH-STANDARD-IO-SYNTAX" "WRITE" "WRITE-BYTE" "WRITE-CHAR"
   "WRITE-LINE" "WRITE-STRING" "WRITE-TO-STRING"
   "WRITE-SEQUENCE" "Y-OR-N-P" "YES-OR-NO-P" "ZEROP"

   "ADD-METHOD" "ALLOCATE-INSTANCE" "CALL-METHOD"
   "CALL-NEXT-METHOD" "CHANGE-CLASS"
   "COMPUTE-APPLICABLE-METHODS" "DEFCLASS" "DEFGENERIC"
   "DEFINE-METHOD-COMBINATION" "DEFMETHOD" "DESCRIBE-OBJECT"
   "ENSURE-GENERIC-FUNCTION"
   "FIND-METHOD" "FUNCTION-KEYWORDS"
   "INITIALIZE-INSTANCE" "INVALID-METHOD-ERROR"
   "MAKE-INSTANCE" "MAKE-INSTANCES-OBSOLETE"
   "METHOD-COMBINATION-ERROR" "METHOD-QUALIFIERS" "NEXT-METHOD-P"
   "NO-APPLICABLE-METHOD" "NO-NEXT-METHOD" "PRINT-OBJECT"
   "REINITIALIZE-INSTANCE" "REMOVE-METHOD" "SHARED-INITIALIZE"
   "SLOT-BOUNDP" "SLOT-EXISTS-P" "SLOT-MAKUNBOUND" "SLOT-MISSING"
   "SLOT-UNBOUND" "SLOT-VALUE" "STANDARD"
   "STANDARD-GENERIC-FUNCTION" "STANDARD-METHOD" "STANDARD-OBJECT"
   "UPDATE-INSTANCE-FOR-DIFFERENT-CLASS"
   "UPDATE-INSTANCE-FOR-REDEFINED-CLASS" "WITH-ACCESSORS" "WITH-SLOTS"
   "MAKE-METHOD" "UNBOUND-SLOT" "UNBOUND-SLOT-INSTANCE"
   "CELL-ERROR-NAME"
   "GET-SETF-EXPANSION" "STYLE-WARNING" 
   "PRINT-NOT-READABLE-OBJECT"
   "DEFINE-SETF-EXPANDER" "PRINT-NOT-READABLE" "METHOD"
   "METHOD-COMBINATION" 
   "MAKE-LOAD-FORM" "MAKE-LOAD-FORM-SAVING-SLOTS"
   "CHAR-TITLECASE" "TITLE-CASE-P"
   "GLYPH" "SGLYPH"
   "STRING-TO-NFC"
   "CODEPOINT-LIMIT" "CODEPOINT")
  ;; Unicode
  (:export "STRING-TO-NFC" "STRING-TO-NFD"
	   "STRING-TO-NFKC" "STRING-TO-NFKD"
	   "UNICODE-COMPLETE" "UNICODE-COMPLETE-NAME"
	   "UNICODE-FULL-CASE-LOWER"
	   "UNICODE-FULL-CASE-UPPER"
	   "UNICODE-FULL-CASE-TITLE"
	   "UNICODE-CATEGORY"
	   "+UNICODE-CATEGORY-LOWER+"
	   "+UNICODE-CATEGORY-OTHER+"
	   "+UNICODE-CATEGORY-GRAPHIC+"
	   "+UNICODE-CATEGORY-UPPER+"
	   "+UNICODE-CATEGORY-TITLE+"
	   "LOAD-ALL-UNICODE-DATA"
	   "SURROGATES"
	   "WITH-STRING-CODEPOINT-ITERATOR"
	   "WITH-STRING-GLYPH-ITERATOR"))

(defpackage "EVAL"
  (:export "*EVAL-STACK-TRACE*" "*INTERNAL-APPLY-NODE-TRACE*"
	   "*INTERPRETED-FUNCTION-CACHE-MINIMUM-SIZE*"
	   "*INTERPRETED-FUNCTION-CACHE-THRESHOLD*"
	   "FLUSH-INTERPRETED-FUNCTION-CACHE" "INTERNAL-EVAL"
	   "INTERPRETED-FUNCTION"
	   "INTERPRETED-FUNCTION-ARGLIST" "INTERPRETED-FUNCTION-CLOSURE"
	   "INTERPRETED-FUNCTION-LAMBDA-EXPRESSION"
	   "INTERPRETED-FUNCTION-NAME" "INTERPRETED-FUNCTION-P"
	   "INTERPRETED-FUNCTION-TYPE" "MAKE-INTERPRETED-FUNCTION"
	   "TRACE-EVAL"))
(dolist
    (name
     '("%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET" "%PUT" "%RPLACA" "%RPLACD"
       "%SBITSET" "%SCHARSET" "%SET-FDEFINITION"
       "%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF" "%SETELT" "%SETNTH"
       "%SP-STRING-COMPARE" "%SVSET" "%TYPEP" "*READ-ONLY-SPACE-FREE-POINTER*"
       "*STATIC-SPACE-FREE-POINTER*" "CURRENT-DYNAMIC-SPACE-START"
       "DYNAMIC-0-SPACE-START" "DYNAMIC-1-SPACE-START" "FIXNUM"
       "READ-ONLY-SPACE-START" "SHORT-FLOAT-P" "STATIC-SPACE-START"
       "STRING/=*" "STRING<*" "STRING<=*" "STRING=*" "STRING>*" "STRING>=*"))
  (intern name "LISP"))
(dolist (name '("%PRIMITIVE" "%STANDARD-CHAR-P"))
  (intern name "SYSTEM"))
(intern "BIGNUM-TYPE" "BIGNUM")
(dolist
    (name
     '("%SP-SET-DEFINITION" "%SP-SET-PLIST" "ARRAY-HEADER-P" "BASE-CHAR-P"
       "DOUBLE-FLOAT-P" "LONG-FLOAT-P" "SIMPLE-ARRAY-P" "SINGLE-FLOAT-P"
       "DOUBLE-DOUBLE-FLOAT-P"
       "DOUBLE-DOUBLE-FLOAT"))
  (intern name "KERNEL"))

(defpackage #+pmax "PMAX"
	    #+sparc "SPARC"
	    #+ibmrt "RT"
            #+x86 "X86"
            #+amd64 "AMD64"
	    #+hppa "HPPA"
	    #+alpha "ALPHA"
	    #+sgi "SGI"
	    #+ppc "PPC"
            (:nicknames "VM" #+(or pmax sgi) "MIPS")
            (:import-from "LISP" "%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET"
             "%PUT" "%RPLACA" "%RPLACD" "%SBITSET" "%SCHARSET"
             "%SET-FDEFINITION" "%SET-FILL-POINTER"
             "%SET-ROW-MAJOR-AREF" "%SETELT" "%SETNTH" "%SP-STRING-COMPARE"
             "%SVSET" "%TYPEP" "*READ-ONLY-SPACE-FREE-POINTER*"
             "*STATIC-SPACE-FREE-POINTER*" "CURRENT-DYNAMIC-SPACE-START"
             "DYNAMIC-0-SPACE-START" "DYNAMIC-1-SPACE-START" "FIXNUM"
             "READ-ONLY-SPACE-START" "SHORT-FLOAT-P" "STATIC-SPACE-START"
	     "STRING/=*" "STRING<*" "STRING<=*" "STRING=*"
             "STRING>*" "STRING>=*")
  (:shadowing-import-from "KERNEL" "CLASS" "BUILT-IN-CLASS" "STANDARD-CLASS"
			  "STRUCTURE-CLASS" "FIND-CLASS" "CLASS-OF")
  (:export "*ASSEMBLY-UNIT-LENGTH*" "*PRIMITIVE-OBJECTS*"
	   "AFTER-BREAKPOINT-TRAP"
	   "ANY-REG-SC-NUMBER" "ARRAY-DATA-SLOT" "ARRAY-DIMENSIONS-OFFSET"
	   "ARRAY-DISPLACED-P-SLOT" "ARRAY-DISPLACEMENT-SLOT"
	   "ARRAY-ELEMENTS-SLOT" "ARRAY-FILL-POINTER-P-SLOT"
	   "ARRAY-FILL-POINTER-SLOT" "ATOMIC-FLAG" "BASE-CHAR-REG-SC-NUMBER"
	   "BASE-CHAR-STACK-SC-NUMBER" "BASE-CHAR-TYPE"
	   "BIGNUM-DIGITS-OFFSET" "BIGNUM-TYPE" "BINDING-SIZE"
	   "BINDING-SYMBOL-SLOT" "BINDING-VALUE-SLOT" "BREAKPOINT-TRAP"
	   "BYTE-CODE-CLOSURE-TYPE" "BYTE-CODE-FUNCTION-TYPE"
	   "BYTE-BITS" "BYTE-REG-SC-NUMBER"
	   "CATCH-BLOCK-CURRENT-CODE-SLOT"
	   "CATCH-BLOCK-CURRENT-CONT-SLOT" "CATCH-BLOCK-CURRENT-UWP-SLOT"
	   "CATCH-BLOCK-ENTRY-PC-SLOT" "CATCH-BLOCK-PREVIOUS-CATCH-SLOT"
	   "CATCH-BLOCK-SC-NUMBER" "CATCH-BLOCK-SIZE" "CATCH-BLOCK-SIZE-SLOT"
	   "CATCH-BLOCK-TAG-SLOT" "CERROR-TRAP"
	   "CLOSURE-FUNCTION-HEADER-TYPE" "CLOSURE-FUNCTION-SLOT"
	   "CLOSURE-HEADER-TYPE" "CLOSURE-INFO-OFFSET" "CODE-BREAKDOWN"
	   "CODE-CODE-SIZE-SLOT" "CODE-CONSTANTS-OFFSET"
	   "CODE-DEBUG-INFO-SLOT" "CODE-ENTRY-POINTS-SLOT" "CODE-HEADER-TYPE"
	   "CODE-TRACE-TABLE-OFFSET-SLOT" "COMPLEX-ARRAY-TYPE"
	   "COMPLEX-BIT-VECTOR-TYPE" "COMPLEX-DOUBLE-FLOAT-FILLER-SLOT"
	   "COMPLEX-DOUBLE-FLOAT-IMAG-SLOT" "COMPLEX-DOUBLE-FLOAT-REAL-SLOT"
	   "COMPLEX-DOUBLE-FLOAT-SIZE" "COMPLEX-DOUBLE-FLOAT-TYPE"
	   "COMPLEX-DOUBLE-REG-SC-NUMBER" "COMPLEX-DOUBLE-STACK-SC-NUMBER" 
	   "COMPLEX-IMAG-SLOT" "COMPLEX-REAL-SLOT"
	   "COMPLEX-LONG-FLOAT-IMAG-SLOT" "COMPLEX-LONG-FLOAT-REAL-SLOT"
	   "COMPLEX-LONG-FLOAT-SIZE" "COMPLEX-LONG-FLOAT-TYPE"
	   "COMPLEX-LONG-REG-SC-NUMBER" "COMPLEX-LONG-STACK-SC-NUMBER" 
	   "COMPLEX-SINGLE-FLOAT-IMAG-SLOT" "COMPLEX-SINGLE-FLOAT-REAL-SLOT"
	   "COMPLEX-SINGLE-FLOAT-SIZE" "COMPLEX-SINGLE-FLOAT-TYPE"
	   "COMPLEX-SINGLE-REG-SC-NUMBER" "COMPLEX-SINGLE-STACK-SC-NUMBER"
	   "COMPLEX-SIZE" "COMPLEX-STRING-TYPE" "COMPLEX-TYPE"
	   "COMPLEX-VECTOR-TYPE" "CONS-CAR-SLOT" "CONS-CDR-SLOT" "CONS-SIZE"
	   "CONSTANT-SC-NUMBER" "CONTROL-STACK-FORK" "CONTROL-STACK-RESUME"
	   "CONTROL-STACK-RETURN" "CONTROL-STACK-SC-NUMBER" "COUNT-NO-OPS"
	   "CURRENT-FLOAT-TRAP" "DEFINE-FOR-EACH-PRIMITIVE-OBJECT"
	   "DESCRIPTOR-REG-SC-NUMBER" "DESCRIPTOR-VS-NON-DESCRIPTOR-STORAGE"
	   "DOUBLE-FLOAT-EXPONENT-BYTE" "DOUBLE-FLOAT-BIAS"
	   "DOUBLE-FLOAT-DIGITS" "DOUBLE-FLOAT-EXPONENT-BYTE"
	   "DOUBLE-FLOAT-FILLER-SLOT" "DOUBLE-FLOAT-HIDDEN-BIT"
	   "DOUBLE-FLOAT-NORMAL-EXPONENT-MAX"
	   "DOUBLE-FLOAT-NORMAL-EXPONENT-MIN" "DOUBLE-FLOAT-SIGNIFICAND-BYTE"
	   "DOUBLE-FLOAT-SIZE" "DOUBLE-FLOAT-TRAPPING-NAN-BIT"
	   "DOUBLE-FLOAT-TYPE" "DOUBLE-FLOAT-VALUE-SLOT"
	   "DOUBLE-INT-CARG-REG-SC-NUMBER" "DOUBLE-REG-SC-NUMBER"
	   "DOUBLE-STACK-SC-NUMBER" "DYLAN-FUNCTION-HEADER-TYPE"
	   "ERROR-TRAP" "EVEN-FIXNUM-TYPE"
	   "EXPORTED-STATIC-SYMBOLS" "EXTERN-ALIEN-NAME"
	   "FDEFN-FUNCTION-SLOT" "FDEFN-NAME-SLOT" "FDEFN-RAW-ADDR-SLOT"
	   "FDEFN-SIZE" "FDEFN-TYPE" "FIND-HOLES" "FIXNUM"
	   "FIXUP-CODE-OBJECT" "FLOAT-DENORMAL-TRAP-BIT"
	   "FLOAT-DIVIDE-BY-ZERO-TRAP-BIT"
	   "FLOAT-IMPRECISE-TRAP-BIT" "FLOAT-INVALID-TRAP-BIT"
	   "FLOAT-OVERFLOW-TRAP-BIT" "FLOAT-SIGN-SHIFT"
	   "FLOAT-UNDERFLOW-TRAP-BIT" "FLOATING-POINT-MODES"
	   "FORWARDING-POINTER-TYPE"
	   "FP-CONSTANT-SC-NUMBER"
	   "FP-DOUBLE-ZERO-SC-NUMBER" "FP-SINGLE-ZERO-SC-NUMBER"
	   "FUNCALLABLE-INSTANCE-FUNCTION-SLOT"
	   "FUNCALLABLE-INSTANCE-HEADER-TYPE" 
	   "FUNCALLABLE-INSTANCE-INFO-OFFSET"
	   "FUNCTION-ARGLIST-SLOT" "FUNCTION-CODE-OFFSET"
	   "FUNCTION-END-BREAKPOINT-TRAP" "FUNCTION-HEADER-TYPE"
	   "FUNCTION-NAME-SLOT" "FUNCTION-NEXT-SLOT" "FUNCTION-POINTER-TYPE"
	   "FUNCTION-SELF-SLOT" "FUNCTION-TYPE-SLOT"
	   "FUNCALLABLE-INSTANCE-LAYOUT-SLOT"
	   "FUNCALLABLE-INSTANCE-LEXENV-SLOT"
	   "GENESIS" "HALT-TRAP" "IGNORE-ME-SC-NUMBER"
	   "IMMEDIATE-BASE-CHAR-SC-NUMBER" "IMMEDIATE-SAP-SC-NUMBER"
	   "IMMEDIATE-SC-NUMBER"
	   "INSTANCE-HEADER-TYPE" "INSTANCE-POINTER-TYPE"
	   "INSTANCE-SLOTS-OFFSET" "INSTANCE-USAGE"
	   "INTERIOR-REG-SC-NUMBER" "INTERNAL-ERROR-ARGUMENTS"
	   "INTERRUPTED-FLAG" "LIST-ALLOCATED-OBJECTS" "LIST-POINTER-TYPE"
	   "LONG-FLOAT-BIAS" "LONG-FLOAT-DIGITS" "LONG-FLOAT-EXPONENT-BYTE"
	   "LONG-FLOAT-HIDDEN-BIT" "LONG-FLOAT-NORMAL-EXPONENT-MAX"
	   "LONG-FLOAT-NORMAL-EXPONENT-MIN" "LONG-FLOAT-SIGNIFICAND-BYTE"
	   "LONG-FLOAT-SIZE" "LONG-FLOAT-TRAPPING-NAN-BIT" "LONG-FLOAT-TYPE"
	   "LONG-FLOAT-VALUE-SLOT" "LONG-REG-SC-NUMBER" "LONG-STACK-SC-NUMBER"
	   "LOWTAG-BITS" "LOWTAG-LIMIT" "LOWTAG-MASK"
	   "MEMORY-USAGE" "MOST-POSITIVE-COST"
	   "NEGATIVE-IMMEDIATE-SC-NUMBER" "NON-DESCRIPTOR-REG-SC-NUMBER"
	   "NULL-SC-NUMBER" "OBJECT-NOT-LIST-TRAP" "OBJECT-NOT-INSTANCE-TRAP"
	   "ODD-FIXNUM-TYPE" "OFFSET-STATIC-SYMBOL" "OTHER-IMMEDIATE-0-TYPE"
	   "OTHER-IMMEDIATE-1-TYPE" "OTHER-POINTER-TYPE"
	   "PAD-DATA-BLOCK" "PENDING-INTERRUPT-TRAP"
	   "PRIMITIVE-OBJECT" "PRIMITIVE-OBJECT-HEADER"
	   "PRIMITIVE-OBJECT-LOWTAG" "PRIMITIVE-OBJECT-NAME"
	   "PRIMITIVE-OBJECT-OPTIONS" "PRIMITIVE-OBJECT-P"
	   "PRIMITIVE-OBJECT-SIZE" "PRIMITIVE-OBJECT-SLOTS"
	   "PRIMITIVE-OBJECT-VARIABLE-LENGTH" "PRINT-ALLOCATED-OBJECTS"
	   "RANDOM-IMMEDIATE-SC-NUMBER" "RATIO-DENOMINATOR-SLOT"
	   "RATIO-NUMERATOR-SLOT" "RATIO-SIZE" "RATIO-TYPE"
	   "REGISTER-SAVE-PENALTY" "RETURN-PC-HEADER-TYPE"
	   "RETURN-PC-RETURN-POINT-OFFSET" "SANCTIFY-FOR-EXECUTION"
	   "SAP-POINTER-SLOT" "SAP-REG-SC-NUMBER" "SAP-SIZE"
	   "SAP-STACK-SC-NUMBER" "SAP-TYPE"
	   "SCAVENGER-HOOK-FUNCTION-SLOT" "SCAVENGER-HOOK-SIZE"
	   "SCAVENGER-HOOK-TYPE" "SCAVENGER-HOOK-VALUE-SLOT"
	   "SCAVENGER-HOOK-NEXT-SLOT"
	   "SIGCONTEXT-FLOATING-POINT-MODES" "SIGCONTEXT-FLOAT-REGISTER"
	   "SIGCONTEXT-PROGRAM-COUNTER" "SIGCONTEXT-REGISTER"
	   "SIGFPE-HANDLER" "SIGNED-REG-SC-NUMBER" "SIGNED-STACK-SC-NUMBER"
	   "SIMPLE-ARRAY-COMPLEX-DOUBLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-COMPLEX-LONG-FLOAT-TYPE"
	   "SIMPLE-ARRAY-COMPLEX-SINGLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-DOUBLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-LONG-FLOAT-TYPE"
	   "SIMPLE-ARRAY-SINGLE-FLOAT-TYPE"
	   "SIMPLE-ARRAY-TYPE" "SIMPLE-ARRAY-UNSIGNED-BYTE-16-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-2-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-32-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-4-TYPE"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-8-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-16-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-30-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-32-TYPE"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-8-TYPE"
	   "SIMPLE-BIT-VECTOR-TYPE"
	   "SIMPLE-STRING-TYPE" "SIMPLE-VECTOR-TYPE" "SINGLE-FLOAT-BIAS"
	   "SINGLE-FLOAT-DIGITS" "SINGLE-FLOAT-EXPONENT-BYTE"
	   "SINGLE-FLOAT-HIDDEN-BIT" "SINGLE-FLOAT-NORMAL-EXPONENT-MAX"
	   "SINGLE-FLOAT-NORMAL-EXPONENT-MIN" "SINGLE-FLOAT-SIGNIFICAND-BYTE"
	   "SINGLE-FLOAT-SIZE" "SINGLE-FLOAT-TRAPPING-NAN-BIT"
	   "SINGLE-FLOAT-TYPE" "SINGLE-FLOAT-VALUE-SLOT"
           "SINGLE-INT-CARG-REG-SC-NUMBER"
	   "SINGLE-REG-SC-NUMBER" "SINGLE-STACK-SC-NUMBER"
	   "SINGLE-STEP-BREAKPOINT-TRAP"
	   "SINGLE-VALUE-RETURN-BYTE-OFFSET" "SLOT-DOCS"
	   "SLOT-LENGTH" "SLOT-NAME" "SLOT-OFFSET" "SLOT-OPTIONS"
	   "SLOT-REST-P" "STATIC-FUNCTIONS" "STATIC-FUNCTION-OFFSET"
	   "STATIC-SYMBOL-OFFSET" "STATIC-SYMBOL-P" "STATIC-SYMBOLS"
	   "STRUCTURE-USAGE" "SYMBOL-FUNCTION-SLOT"
	   "SYMBOL-HASH-SLOT" "SYMBOL-HEADER-TYPE" "SYMBOL-NAME-SLOT"
	   "SYMBOL-PACKAGE-SLOT" "SYMBOL-PLIST-SLOT"
	   "SYMBOL-RAW-FUNCTION-ADDR-SLOT" "SYMBOL-SETF-FUNCTION-SLOT"
	   "SYMBOL-SIZE" "SYMBOL-UNUSED-SLOT" "SYMBOL-VALUE-SLOT"
	   "TARGET-BINDING-STACK-START" "TARGET-BYTE-ORDER"
	   "TARGET-CONTROL-STACK-START" "TARGET-DYNAMIC-SPACE-START"
	   "TARGET-FASL-CODE-FORMAT" "TARGET-FASL-FILE-TYPE"
	   "TARGET-FOREIGN-LINKAGE-ENTRY-SIZE"
	   "TARGET-FOREIGN-LINKAGE-SPACE-START"
	   "TARGET-HEAP-ADDRESS-SPACE" "TARGET-MOST-NEGATIVE-FIXNUM"
	   "TARGET-MOST-POSITIVE-FIXNUM" "TARGET-READ-ONLY-SPACE-START"
	   "TARGET-STATIC-SPACE-START" "TRACE-TABLE-CALL-SITE"
	   "TRACE-TABLE-FUNCTION-EPILOGUE" "TRACE-TABLE-FUNCTION-PROLOGUE"
	   "TRACE-TABLE-NORMAL" "TYPE-BITS" "TYPE-MASK" "UNBOUND-MARKER-TYPE"
	   "UNINTERNED-SYMBOL-COUNT" "UNSIGNED-IMMEDIATE-SC-NUMBER"
	   "UNSIGNED-REG-SC-NUMBER" "UNSIGNED-STACK-SC-NUMBER"
	   "UNWIND-BLOCK-CURRENT-CODE-SLOT" "UNWIND-BLOCK-CURRENT-CONT-SLOT"
	   "UNWIND-BLOCK-CURRENT-UWP-SLOT" "UNWIND-BLOCK-ENTRY-PC-SLOT"
	   "UNWIND-BLOCK-SIZE" "VALUE-CELL-HEADER-TYPE" "VALUE-CELL-SIZE"
	   "VALUE-CELL-VALUE-SLOT" "VECTOR-DATA-OFFSET" "VECTOR-LENGTH-SLOT"
	   "VECTOR-MUST-REHASH-SUBTYPE" "VECTOR-NORMAL-SUBTYPE"
	   "VECTOR-VALID-HASHING-SUBTYPE"
	   "WEAK-POINTER-BROKEN-SLOT" "WEAK-POINTER-NEXT-SLOT"
	   "WEAK-POINTER-SIZE" "WEAK-POINTER-TYPE" "WEAK-POINTER-VALUE-SLOT"
	   "WORD-BITS" "WORD-BYTES" "WORD-REG-SC-NUMBER" "WORD-SHIFT"
	   "ZERO-SC-NUMBER"
	   "CALLBACK-ACCESSOR-FORM" "MAKE-CALLBACK-TRAMPOLINE"
	   "FIXNUMIZE"
	   "WEAK-POINTER-MARK-BIT-SLOT"
	   "CHAR-BITS" "CHAR-BYTES"
	   )
  #+x86
  (:export "COMPATIBLE-FUNCTION-TYPES-P"
	   "POSITIVE-FIXNUM-BITS"
	   "FIXNUM-TAG-BITS"
	   "FIXNUM-TAG-MASK")
  #+sparc
  (:export "ALLOCATION-TRAP"
	   "POSITIVE-FIXNUM-BITS"
	   "FIXNUM-TAG-BITS"
	   "FIXNUM-TAG-MASK"
	   "PSEUDO-ATOMIC-TRAP"
	   "GET-FP-OPERANDS"
	   "PSEUDO-ATOMIC-VALUE"
	   "PSEUDO-ATOMIC-INTERRUPTED-VALUE"
	   "COMPATIBLE-FUNCTION-TYPES-P"
	   "SINGLE-FLOAT-BYTES"
	   "DOUBLE-FLOAT-BYTES")
  #+ppc
  (:export "SIGCONTEXT-LR"
	   "COMPATIBLE-FUNCTION-TYPES-P"
	   "FLOAT-INVALID-OP-1-BYTE"
	   "FLOAT-INVALID-OP-2-BYTE"
	   "FLOAT-EXCEPTIONS-SUMMARY-BYTE"
	   "GET-FP-OPERANDS"
	   "FUSED-MULTIPLY-ADD"
	   "FUSED-MULTIPLY-SUBTRACT")
  #+heap-overflow-check
  (:export "DYNAMIC-SPACE-OVERFLOW-ERROR-TRAP"
	   "DYNAMIC-SPACE-OVERFLOW-WARNING-TRAP")
  ;;#+double-double
  (:export "DOUBLE-DOUBLE-FLOAT"
	   "DOUBLE-DOUBLE-FLOAT-TYPE"
	   "DOUBLE-DOUBLE-FLOAT-HI-SLOT"
	   "DOUBLE-DOUBLE-FLOAT-LO-SLOT"
	   "DOUBLE-DOUBLE-FLOAT-FILLER-SLOT"
	   "DOUBLE-DOUBLE-FLOAT-SIZE"
	   "DOUBLE-DOUBLE-REG-SC-NUMBER"
	   "DOUBLE-DOUBLE-STACK-SC-NUMBER"
	   "DOUBLE-DOUBLE-FLOAT-DIGITS"
	   "SIMPLE-ARRAY-DOUBLE-DOUBLE-FLOAT-TYPE"

	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-TYPE"
	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-FILLER-SLOT"
	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-REAL-HI-SLOT"
	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-REAL-LO-SLOT"
	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-IMAG-HI-SLOT"
	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-IMAG-LO-SLOT"
	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-SIZE"
	   "COMPLEX-DOUBLE-DOUBLE-REG-SC-NUMBER"
	   "COMPLEX-DOUBLE-DOUBLE-STACK-SC-NUMBER"

	   "SIMPLE-ARRAY-COMPLEX-DOUBLE-DOUBLE-FLOAT-TYPE"
	   ))

(defpackage "CONDITIONS")
(defpackage "DISASSEM"
  (:shadow "DISASSEMBLE")
  (:export "*NOTE-COLUMN*" "*OPCODE-COLUMN-WIDTH*" "ADD-COMMENT-HOOK"
	   "ADD-HOOK" "ADD-NOTE-HOOK" "ARG-VALUE" "CREATE-DSTATE"
	   "DISASSEM-STATE" "DISASSEMBLE" "DISASSEMBLE-CODE-COMPONENT"
	   "DISASSEMBLE-FUNCTION" "DISASSEMBLE-MEMORY"
	   "*DISASSEMBLE-PRINT-RADIX*"
	   "DISASSEMBLE-SEGMENT"
	   "DISASSEMBLE-SEGMENTS" "DSTATE-CODE" "DSTATE-CURPOS"
	   "DSTATE-GET-PROP" "DSTATE-NEXTPOS" "DSTATE-SEGMENT-LENGTH"
	   "DSTATE-SEGMENT-SAP" "DSTATE-SEGMENT-START" "FIELD-TYPE"
	   "FIND-INST" "GEN-FIELD-TYPE-DECL-FORM" "GEN-INST-DECL-FORM"
	   "GEN-INST-FORMAT-DECL-FORM" "GET-CODE-SEGMENTS"
	   "GET-FUNCTION-SEGMENTS" "GET-INST-SPACE" "HANDLE-BREAK-ARGS"
	   "INST" "INST-FORMAT" "LABEL-SEGMENTS"
	   "MAYBE-NOTE-ASSEMBLER-ROUTINE"
	   "MAYBE-NOTE-STATIC-FUNCTION"
	   "MAYBE-NOTE-ASSOCIATED-STORAGE-REF"
	   "MAYBE-NOTE-NIL-INDEXED-OBJECT"
	   "MAYBE-NOTE-NIL-INDEXED-SYMBOL-SLOT-REF"
	   "MAYBE-NOTE-SINGLE-STORAGE-REF" "NOTE" "NOTE-CODE-CONSTANT"
	   "PARAMS" "PRIN1-QUOTED-SHORT" "PRIN1-SHORT" "PRINT-BYTES"
	   "PRINT-CURRENT-ADDRESS" "PRINT-FIELD" "PRINT-INST"
	   "PRINT-INST-USING" "PRINT-NOTES-AND-NEWLINE" "PRINT-WORDS"
	   "SAP-REF-DCHUNK" "SEG-DEBUG-FUNCTION" "SEG-LENGTH" "SEG-START"
	   "SEGMENT" "SET-ADDRESS-PRINTING-RANGE" "SET-DISASSEM-PARAMS"
	   "SET-DSTATE-SEGMENT" "SIGN-EXTEND" "SPECIALIZE"
	   "GEN-PRINTER-DEF-FORMS-DEF-FORM"
	   "MAKE-DSTATE"
	   "DEFINE-ARGUMENT-TYPE"
	   "GEN-ARG-TYPE-DEF-FORM"
	   "READ-SIGNED-SUFFIX"
	   "ADD-OFFS-HOOK"
	   "MAKE-MEMORY-SEGMENT"
	   "GEN-PREAMBLE-FORM"
	   "MAKE-SEGMENT"
	   "SEGMENT-OVERFLOW"
	   "SEG-VIRTUAL-LOCATION"
	   "MAKE-DECODED-INST"
	   "DCHUNK"
	   "*DEFAULT-DSTATE-HOOKS*"
	   "MAKE-CODE-SEGMENT"
	   "MAKE-OFFS-HOOK"
	   "DSTATE-SEGMENT"
	   "DSTATE-CUR-OFFS"
	   "PRINC16"
	   "INSTRUCTION"
	   "DEFINE-INSTRUCTION-FORMAT"
	   "DSTATE-NEXT-OFFS"
	   "INSTALL-INST-FLAVORS"
	   "SEG-SAP-MAKER"
	   "DISASSEMBLE-ASSEM-SEGMENT"
	   "GEN-CLEAR-INFO-FORM"
	   "READ-SUFFIX"
	   "MAP-SEGMENT-INSTRUCTIONS"
	   "GEN-FORMAT-DEF-FORM"
	   "SET-LOCATION-PRINTING-RANGE"
	   "MAKE-VECTOR-SEGMENT"
	   "ADD-OFFS-NOTE-HOOK"
	   "ADD-OFFS-COMMENT-HOOK"
	   "DSTATE-CUR-ADDR"
	   "DSTATE-NEXT-ADDR"
	   #+sparc "MAYBE-NOTE-STATIC-FUNCTION"
	   ))
(dolist
    (name
     '("*MAX-TRACE-INDENTATION*"
       "*TRACED-FUNCTION-LIST*"))
  (intern name "EXTENSIONS"))
(defpackage "DEBUG"
  (:import-from "EXTENSIONS" "*MAX-TRACE-INDENTATION*"
		"*TRACED-FUNCTION-LIST*")
  (:export "*AUTO-EVAL-IN-FRAME*" "*DEBUG-PRINT-LENGTH*"
	   "*DEBUG-PRINT-LEVEL*" "*DEBUG-PROMPT*"
	   "*DEBUG-READTABLE*" "*FLUSH-DEBUG-ERRORS*"
	   "*HELP-LINE-SCROLL-COUNT*" "*IN-THE-DEBUGGER*"
	   "*MAX-TRACE-INDENTATION*" "*TRACE-FRAME*"
	   "*TRACED-FUNCTION-LIST*" "ARG" "BACKTRACE"
	   "INTERNAL-DEBUG" "VAR" "*PRINT-LOCATION-KIND*"
	   "*ONLY-BLOCK-START-LOCATIONS*" "*STACK-TOP-HINT*"
	   "*TRACE-VALUES*" "DO-DEBUG-COMMAND"
	   "*TRACE-ENCAPSULATE-DEFAULT*"
	   "*TRACE-ENCAPSULATE-PACKAGE-NAMES*"
	   "*DEFAULT-PRINT-FRAME-CALL-VERBOSITY*"))

(intern "CHAR" "LISP")

;; Make these STREAM symbols available
(dolist
    (name
      '("STRING-TO-OCTETS" "OCTETS-TO-STRING" "*DEFAULT-EXTERNAL-FORMAT*"
	"STRING-ENCODE" "STRING-DECODE" "SET-SYSTEM-EXTERNAL-FORMAT"
	"LIST-ALL-EXTERNAL-FORMATS" "DESCRIBE-EXTERNAL-FORMAT"))
  (intern name "STREAM"))

(defpackage "EXTENSIONS"
  (:nicknames "EXTENSIONS")
  (:import-from "LISP" "GET-SETF-METHOD")
  (:import-from "KERNEL" "*ANSI-DEFSTRUCT-OPTIONS-P*")
  (:import-from "SYSTEM" "MAKE-INDENTING-STREAM" "INDENTING-STREAM-P"
		"BINARY-TEXT-STREAM")
  #+double-double
  (:import-from "KERNEL" "DOUBLE-DOUBLE-FLOAT" "DD-PI")
  (:export   "*AFTER-GC-HOOKS*" "*AFTER-SAVE-INITIALIZATIONS*"
	     "DEBUG"
	     "FLOATING-POINT-INEXACT"
	     "*ANSI-DEFSTRUCT-OPTIONS-P*"
	     "*AUTOLOAD-TRANSLATIONS*"
	     "*BACKUP-EXTENSION*" "*BEFORE-GC-HOOKS*"
             "*BEFORE-SAVE-INITIALIZATIONS*" "*BLOCK-COMPILE-DEFAULT*"
             "*BYTES-CONSED-BETWEEN-GCS*"
             "*COMPATIBILITY-WARNINGS*"
             "*COMPILE-PROGRESS*" "*DERIVE-FUNCTION-TYPES*"
             "*DESCRIBE-IMPLEMENTATION-DETAILS*" "*DESCRIBE-INDENTATION*"
             "*DESCRIBE-LEVEL*" "*DESCRIBE-PRINT-LENGTH*"
             "*DESCRIBE-PRINT-LEVEL*" "*DESCRIBE-VERBOSE*"
             "*DISPLAY-EVENT-HANDLERS*" "*EDITOR-LISP-P*"
             "*EFFICIENCY-NOTE-COST-THRESHOLD*" "*EFFICIENCY-NOTE-LIMIT*"
             "*ENCLOSING-SOURCE-CUTOFF*" "*ENVIRONMENT-LIST*"
             "*ERROR-PRINT-LENGTH*" "*ERROR-PRINT-LEVEL*" "*GC-INHIBIT-HOOK*"
             "*GC-NOTIFY-AFTER*" "*GC-NOTIFY-BEFORE*" "*GC-VERBOSE*"
	     "GET-SETF-METHOD" ; temp until uses are converted to g-s-expansion
             "*IGNORE-FLOATING-POINT-UNDERFLOW*"
             "*INFO-ENVIRONMENT*" "*INTEXP-MAXIMUM-EXPONENT*"
             "*KEYWORD-PACKAGE*" "*LISP-PACKAGE*" "*LOAD-IF-SOURCE-NEWER*"
             "*MAX-TRACE-INDENTATION*" "*MODULE-FILE-TRANSLATIONS*"
	     "*PROMPT*" "*REQUIRE-VERBOSE*" "*MODULE-PROVIDER-FUNCTIONS*"
	     "*SETF-FDEFINITION-HOOK*"
             "*TOP-LEVEL-AUTO-DECLARE*"
	     "COMPILER-MACROEXPAND-1" "COMPILER-MACROEXPAND"
             "*UNDEFINED-WARNING-LIMIT*"
             "AMBIGUOUS-FILES" "ARGUMENT-LIST" "ASSQ"
             "BASIC-DEFINITION" "BIGNUMP" "BITP"
             "CALL-USER-MISCOP" "CANCEL-FINALIZATION" "CAREFUL-SYMBOL-FUNCTION"
             "CHAR"
             "CLEAN-UP-COMPILER" "CLEAR-INFO" "CLEAR-SEARCH-LIST"
             "COMPACT-INFO-ENVIRONMENT" "COMPILE-FROM-STREAM" "COMPILEDP"
             "COMPLETE-FILE"
             "CONSTANT" "CONSTANT-ARGUMENT" "CONSTANT-FUNCTION"
	     "DEF-SOURCE-CONTEXT"
             "DEFAULT-DIRECTORY"
             "DEFINE-INFO-CLASS"
             "DEFINE-INFO-TYPE"
             "DEFMODULE"
             "DELQ"
             "DO-INFO"
             "ENCAPSULATE" "ENCAPSULATED-DEFINITION" "ENCAPSULATED-P"
             "END-BLOCK" "ENUMERATE-SEARCH-LIST" "FILE-WRITABLE"
             "FINALIZE" "FIXNUMP"
             "FORMAT-DECODED-TIME" "FORMAT-UNIVERSAL-TIME" "FREEZE-TYPE" "GC"
             "GC-OFF" "GC-ON" "GET-BYTES-CONSED" "GET-BYTES-CONSED-DFIXNUM"
	     "GET-STREAM-COMMAND"
             "INFO"
             "INHIBIT-WARNINGS" "INTERACTIVE-EVAL"
             "LOAD-FOREIGN"
             "MAKE-CASE-FROB-STREAM" "MAKE-INFO-ENVIRONMENT"
             "MAKE-SCAVENGER-HOOK"
	     "MAKE-STREAM-COMMAND" "MAKE-WEAK-POINTER"
             "MAYBE-INLINE" "MEMQ"
             "OPTIMIZE-INTERFACE"
	     "PACKAGE-CHILDREN" "PACKAGE-PARENT" "PARSE-TIME"
             "PACKAGE-LOCK" "PACKAGE-DEFINITION-LOCK" "WITHOUT-PACKAGE-LOCKS"
	     "UNLOCK-ALL-PACKAGES"
             "PRINT-DIRECTORY" "PRINT-HERALD"
             "PUTF" "PURGE-BACKUP-FILES" "QUIT" "RATIOP"
             "REALP"
             "RESET-FOREIGN-POINTERS"
             "SAVE" "SAVE-LISP"
             "SCAVENGER-HOOK" "SCAVENGER-HOOK-P"
	     "SCAVENGER-HOOK-VALUE" "SCAVENGER-HOOK-FUNCTION"
	     "SEARCH-LIST"

             "SET-SYMBOL-FUNCTION-CAREFULLY"
             "START-BLOCK" "STREAM-COMMAND"
             "STREAM-COMMAND-ARGS" "STREAM-COMMAND-NAME" "STREAM-COMMAND-P"
	     "INSTANCEP" "SYMBOLICATE"
             "TRULY-THE" "UNCOMPILE"
             "UNENCAPSULATE" "UNIX-NAMESTRING" "WEAK-POINTER"
             "WEAK-POINTER-P" "WEAK-POINTER-VALUE"
	     "FEATUREP" "*IGNORE-EXTRA-CLOSE-PARENTHESES*" "*HERALD-ITEMS*"
	     "SEARCH-LIST-DEFINED-P" "BYTES-CONSED-BETWEEN-GCS"
	     "*LOAD-SOURCE-TYPES*" "*LOAD-OBJECT-TYPES*"
	     "*DEFAULT-PACKAGE-USE-LIST*" "*GC-RUN-TIME*"
	     "DEFINE-HASH-TABLE-TEST"

	     "*EFFICIENCY-NOTE-LIMIT*"
	     "*ERROR-PRINT-LINES*"
	     "*INLINE-EXPANSION-LIMIT*"
	     "INSTANCE"
	     "*EFFICIENCY-NOTE-COST-THRESHOLD*"
	     "*USE-IMPLEMENTATION-TYPES*"
	     "*BYTE-COMPILE-TOP-LEVEL*"
	     "*BYTE-COMPILE-DEFAULT*"
	     "PURIFY" "MAP-APROPOS"
	     "COMPILER-LET"
	     "DEFINE-FUNCTION-NAME-SYNTAX"
	     "VALID-FUNCTION-NAME-P"

             "MAKE-INDENTING-STREAM" "INDENTING-STREAM-P"

	     "&PARSE-BODY"

	     "*TRUST-DYNAMIC-EXTENT-DECLARATIONS*"

	     "INVALID-FASL")
  ;; gencgc features
  #+gencgc
  (:export "GET-GC-ASSERTIONS"
	   "SET-GC-ASSERTIONS")

  ;; run-program
  (:export "RUN-PROGRAM" "PROCESS-ALIVE-P" "PROCESS-CLOSE"
	   "PROCESS-CORE-DUMPED" "PROCESS-ERROR" "PROCESS-EXIT-CODE"
	   "PROCESS-INPUT" "PROCESS-KILL" "PROCESS-OUTPUT" "PROCESS-P"
	   "PROCESS-PID" "PROCESS-PLIST" "PROCESS-PTY" "PROCESS-STATUS"
	   "PROCESS-STATUS-HOOK" "PROCESS-WAIT")

  ;; Float extensions
  (:export "SINGLE-FLOAT-POSITIVE-INFINITY" "SHORT-FLOAT-POSITIVE-INFINITY"
	   "DOUBLE-FLOAT-POSITIVE-INFINITY" "LONG-FLOAT-POSITIVE-INFINITY"
	   "SINGLE-FLOAT-NEGATIVE-INFINITY" "SHORT-FLOAT-NEGATIVE-INFINITY"
	   "DOUBLE-FLOAT-NEGATIVE-INFINITY" "LONG-FLOAT-NEGATIVE-INFINITY"
	   "GET-FLOATING-POINT-MODES"
	   "SET-FLOATING-POINT-MODES"
	   "ENCODE-FLOATING-POINT-MODES"
	   "DECODE-FLOATING-POINT-MODES"
	   "FLOAT-DENORMALIZED-P" "FLOAT-INFINITY-P"
	   "FLOAT-NAN-P" "FLOAT-TRAPPING-NAN-P"
	   "FLOAT-SIGNALING-NAN-P"
	   "WITH-FLOAT-TRAPS-MASKED"
	   "WITH-FLOAT-TRAPS-ENABLED")
  ;; More float extensions
  #+double-double
  (:export "LEAST-POSITIVE-NORMALIZED-DOUBLE-DOUBLE-FLOAT"
	   "LEAST-NEGATIVE-NORMALIZED-DOUBLE-DOUBLE-FLOAT"
	   "LEAST-POSITIVE-DOUBLE-DOUBLE-FLOAT"
	   "LEAST-NEGATIVE-DOUBLE-DOUBLE-FLOAT"
	   "MOST-POSITIVE-DOUBLE-DOUBLE-FLOAT"
	   "MOST-NEGATIVE-DOUBLE-DOUBLE-FLOAT"
	   "DOUBLE-DOUBLE-FLOAT-NEGATIVE-INFINITY"
	   "DOUBLE-DOUBLE-FLOAT-POSITIVE-INFINITY")

  ;; Spice lisp extensions
  (:export "LETF*" "LETF" "DOVECTOR" "DELETEF" "INDENTING-FURTHER" "FILE-COMMENT"
	   "READ-CHAR-NO-EDIT" "LISTEN-SKIP-WHITESPACE" "CONCAT-PNAMES"
	   "ITERATE" "ONCE-ONLY" "COLLECT" "DO-ANONYMOUS" "UNDEFINED-VALUE"
	   "REQUIRED-ARGUMENT" "DEFINE-HASH-CACHE" "DEFUN-CACHED"
	   "CACHE-HASH-EQ" "DO-HASH")
  
  ;; Gray streams extension.
  (:export "FUNDAMENTAL-BINARY-STREAM" "FUNDAMENTAL-BINARY-INPUT-STREAM"
	   "FUNDAMENTAL-BINARY-OUTPUT-STREAM" "FUNDAMENTAL-CHARACTER-STREAM"
	   "FUNDAMENTAL-CHARACTER-INPUT-STREAM"
	   "FUNDAMENTAL-CHARACTER-OUTPUT-STREAM"
	   "FUNDAMENTAL-INPUT-STREAM" "FUNDAMENTAL-OUTPUT-STREAM"
	   "FUNDAMENTAL-STREAM"
	   "STREAM-ADVANCE-TO-COLUMN" "STREAM-CLEAR-INPUT" 
	   "STREAM-CLEAR-OUTPUT"
	   "STREAM-FILE-POSITION"
	   "STREAM-FINISH-OUTPUT" "STREAM-FORCE-OUTPUT"
	   "STREAM-FRESH-LINE" "STREAM-LINE-COLUMN" "STREAM-LINE-LENGTH"
	   "STREAM-LISTEN" "STREAM-PEEK-CHAR" "STREAM-READ-BYTE"
	   "STREAM-READ-CHAR" "STREAM-READ-CHAR-NO-HANG" "STREAM-READ-LINE"
	   "STREAM-START-LINE-P" "STREAM-TERPRI" "STREAM-UNREAD-CHAR"
	   "STREAM-WRITE-BYTE" "STREAM-WRITE-CHAR" "STREAM-WRITE-STRING"
	   "STREAM-READ-SEQUENCE" "STREAM-WRITE-SEQUENCE")

  ;; Commandline parsing
  (:export "*COMMAND-LINE-WORDS*" "*COMMAND-LINE-SWITCHES*"
	   "*COMMAND-SWITCH-DEMONS*" "*COMMAND-LINE-UTILITY-NAME*"
	   "*COMMAND-LINE-STRINGS*" "*BATCH-MODE*"
	   "*COMMAND-LINE-APPLICATION-ARGUMENTS*"
	   "CMD-SWITCH-STRING" "COMMAND-LINE-SWITCH-P"
	   "CMD-SWITCH-NAME" "CMD-SWITCH-VALUE" "CMD-SWITCH-WORDS" "COMMAND-LINE-SWITCH"
	   "DEFSWITCH" "CMD-SWITCH-ARG" "GET-COMMAND-LINE-SWITCH")
  
  ;; PCL declaration identifiers.
  (:export "SLOTS" "AUTO-COMPILE" "NOT-AUTO-COMPILE")

  ;; From internet.lisp
  (:export "HTONL" "NTOHL" "HTONS" "NTOHS" "LOOKUP-HOST-ENTRY" "HOST-ENTRY"
	   "HOST-ENTRY-NAME" "HOST-ENTRY-ALIASES" "HOST-ENTRY-ADDR-LIST"
	   "HOST-ENTRY-ADDR" "IP-STRING" "BIND-INET-SOCKET"
	   "CREATE-UNIX-SOCKET" "CONNECT-TO-UNIX-SOCKET"
	   "CREATE-UNIX-LISTENER" "ACCEPT-UNIX-CONNECTION" "CREATE-INET-SOCKET"
	   "CONNECT-TO-INET-SOCKET" "CREATE-INET-LISTENER" "ACCEPT-TCP-CONNECTION"
	   "CLOSE-SOCKET" "IPPROTO-TCP" "IPPROTO-UDP" "INADDR-ANY" "ADD-OOB-HANDLER"
	   "REMOVE-OOB-HANDLER" "REMOVE-ALL-OOB-HANDLERS"
	   "SEND-CHARACTER-OUT-OF-BAND"
	   "SOCKET-ERROR" 
	   "INET-RECVFROM" "INET-SENDTO" "INET-SHUTDOWN"
	   "SHUT-RD" "SHUT-WR" "SHUT-RDWR"
	   "GET-PEER-HOST-AND-PORT" "GET-SOCKET-HOST-AND-PORT"

	   "OPEN-NETWORK-STREAM" "ACCEPT-NETWORK-STREAM")
  ;; CLX extensions
  (:export "OPEN-CLX-DISPLAY" "WITH-CLX-EVENT-HANDLING" "ENABLE-CLX-EVENT-HANDLING"
	   "DISABLE-CLX-EVENT-HANDLING" "OBJECT-SET-EVENT-HANDLER"
	   "DEFAULT-CLX-EVENT-HANDLER"
	   "FLUSH-DISPLAY-EVENTS" "CAREFULLY-ADD-FONT-PATHS"
	   ;; Not sure if this should be exported or not.  It's not
	   ;; listed in clx-ext.lisp.
	   "*CLX-FDS-TO-DISPLAYS*"
	   
	   "SERVE-KEY-PRESS" "SERVE-KEY-RELEASE" "SERVE-BUTTON-PRESS"
	   "SERVE-BUTTON-RELEASE" "SERVE-MOTION-NOTIFY" "SERVE-ENTER-NOTIFY"
	   "SERVE-LEAVE-NOTIFY" "SERVE-FOCUS-IN" "SERVE-FOCUS-OUT" 
	   "SERVE-EXPOSURE" "SERVE-GRAPHICS-EXPOSURE" "SERVE-NO-EXPOSURE"
	   "SERVE-VISIBILITY-NOTIFY" "SERVE-CREATE-NOTIFY" "SERVE-DESTROY-NOTIFY"
	   "SERVE-UNMAP-NOTIFY" "SERVE-MAP-NOTIFY" "SERVE-MAP-REQUEST"
	   "SERVE-REPARENT-NOTIFY" "SERVE-CONFIGURE-NOTIFY" "SERVE-GRAVITY-NOTIFY"
	   "SERVE-RESIZE-REQUEST" "SERVE-CONFIGURE-REQUEST" "SERVE-CIRCULATE-NOTIFY"
	   "SERVE-CIRCULATE-REQUEST" "SERVE-PROPERTY-NOTIFY" "SERVE-SELECTION-CLEAR"
	   "SERVE-SELECTION-REQUEST" "SERVE-SELECTION-NOTIFY" "SERVE-COLORMAP-NOTIFY"
	   "SERVE-CLIENT-MESSAGE")

  ;; CLtL2 environment access.
  (:export "VARIABLE-INFORMATION"
	   "FUNCTION-INFORMATION"
	   "DECLARATION-INFORMATION"
	   "PARSE-MACRO"
	   "AUGMENT-ENVIRONMENT")

  ;; CMUCL extension for binary/text streams
  (:export "BINARY-TEXT-STREAM" "READ-VECTOR" "WRITE-VECTOR")

  ;; Hemlock (main.lisp, key-event.lisp, keytran.lisp)
  (:export "DEFINE-KEYSYM" "DEFINE-MOUSE-KEYSYM" "NAME-KEYSYM" "KEYSYM-NAMES"
	   "KEYSYM-PREFERRED-NAME" "DEFINE-KEY-EVENT-MODIFIER" "DEFINE-CLX-MODIFIER"
	   "MAKE-KEY-EVENT-BITS" "KEY-EVENT-MODIFIER-MASK" "KEY-EVENT-BITS-MODIFIERS"
	   "*ALL-MODIFIER-NAMES*" "TRANSLATE-KEY-EVENT" "TRANSLATE-MOUSE-KEY-EVENT"
	   "MAKE-KEY-EVENT" "KEY-EVENT" "KEY-EVENT-P" "KEY-EVENT-BITS" "KEY-EVENT-KEYSYM"
	   "CHAR-KEY-EVENT" "KEY-EVENT-CHAR" "KEY-EVENT-BIT-P" "DO-ALPHA-KEY-EVENTS"
	   "PRINT-PRETTY-KEY" "PRINT-PRETTY-KEY-EVENT" "*HEMLOCK-VERSION*"
	   "DEFINE-MOUSE-CODE" "DEFINE-KEYBOARD-MODIFIER"
	   "TRANSLATE-CHARACTER" "TRANSLATE-MOUSE-CHARACTER")

  #+double-double
  (:export "DOUBLE-DOUBLE-FLOAT" "DD-PI")
  
  (:import-from "STREAM"
		"STRING-TO-OCTETS" "OCTETS-TO-STRING" "*DEFAULT-EXTERNAL-FORMAT*"
		"STRING-ENCODE" "STRING-DECODE"
		"SET-SYSTEM-EXTERNAL-FORMAT"
		"LIST-ALL-EXTERNAL-FORMATS"
		"DESCRIBE-EXTERNAL-FORMAT")
  ;; Unicode
  (:export "STRING-TO-OCTETS" "OCTETS-TO-STRING" "*DEFAULT-EXTERNAL-FORMAT*"
	   "DESCRIBE-EXTERNAL-FORMAT"
	   "LIST-ALL-EXTERNAL-FORMATS"
	   "STRING-ENCODE" "STRING-DECODE"
	   "SET-SYSTEM-EXTERNAL-FORMAT"))

(defpackage "STREAM"
  (:import-from "SYSTEM" "LISP-STREAM")
  (:import-from "EXTENSIONS" "FUNDAMENTAL-STREAM")
  (:import-from "LISP" "LINE-LENGTH" "CHARPOS"
		"BREF" "BUFFER-COPY" "BUFFER-SAP" "ENDIAN-SWAP-VALUE"
		"VECTOR-ELT-WIDTH"
		"SURROGATES" "SURROGATES-TO-CODEPOINT")
  (:export ;; Stream classes
           "STREAM"
           "SIMPLE-STREAM"
           "SINGLE-CHANNEL-SIMPLE-STREAM"
           "DUAL-CHANNEL-SIMPLE-STREAM"
           "STRING-SIMPLE-STREAM"
           "PROBE-SIMPLE-STREAM"
           "DIRECT-SIMPLE-STREAM"
           "BUFFER-INPUT-SIMPLE-STREAM"
           "BUFFER-OUTPUT-SIMPLE-STREAM"
           "NULL-SIMPLE-STREAM"
           "FILE-SIMPLE-STREAM"
           "MAPPED-FILE-SIMPLE-STREAM"
           "TERMINAL-SIMPLE-STREAM"
           "SOCKET-SIMPLE-STREAM"
           "SOCKET-BASE-SIMPLE-STREAM"
           "COMPOSING-STREAM"
           "STRING-INPUT-SIMPLE"
           "STRING-OUTPUT-SIMPLE-STREAM"
           "FILL-POINTER-OUTPUT-SIMPLE-STREAM"
           "XP-SIMPLE-STREAM"
           "ANNOTATION-OUTPUT-SIMPLE-STREAM"
           ;; Standard streams
           "*STANDARD-INPUT*" "*STANDARD-OUTPUT*" "*ERROR-OUTPUT*"
           "*QUERY-IO*" "*DEBUG-IO*" "*TRACE-OUTPUT*" "*TERMINAL-IO*"
           ;; Slot accessors
           "STREAM-INPUT-HANDLE" "STREAM-OUTPUT-HANDLE"
           "STREAM-PLIST"
           ;; Device-level functions
           "DEVICE-OPEN" "DEVICE-CLOSE" "DEVICE-BUFFER-LENGTH"
           "DEVICE-FILE-POSITION" "DEVICE-FILE-LENGTH" "DEVICE-READ"
           "DEVICE-CLEAR-INPUT" "DEVICE-WRITE" "DEVICE-CLEAR-OUTPUT"
           "DEVICE-EXTEND" "DEVICE-FINISH-RECORD"
           ;; Implementation functions/macros
           "DEF-STREAM-CLASS" "WITH-STREAM-CLASS" "SM" "FUNCALL-STM-HANDLER"
           "FUNCALL-STM-HANDLER-2" "ADD-STREAM-INSTANCE-FLAGS"
           "REMOVE-STREAM-INSTANCE-FLAGS" "COMPOSE-ENCAPSULATING-STREAMS"
           ;; User-level functions (mostly reexported from COMMON-LISP)
           "OPEN" "CLOSE" "READ-BYTE" "READ-CHAR" "READ-NO-HANG-P"
	   "READ-CHAR-NO-HANG" "UNREAD-CHAR" "PEEK-CHAR" "LISTEN" "READ-LINE"
	   "READ-SEQUENCE" "CLEAR-INPUT" "WRITE-BYTE" "WRITE-CHAR"
	   "WRITE-NO-HANG-P" "WRITE-STRING" "WRITE-SEQUENCE" "TERPRI"
           "FRESH-LINE" "FINISH-OUTPUT" "FORCE-OUTPUT" "CLEAR-OUTPUT"
           "FILE-POSITION" "FILE-LENGTH" "LINE-LENGTH" "CHARPOS"
           "STREAM-ELEMENT-TYPE" "STREAM-EXTERNAL-FORMAT" "STREAMP"
           "OPEN-STREAM-P" "INPUT-STREAM-P" "OUTPUT-STREAM-P"
           "INTERACTIVE-STREAM-P" "READ-VECTOR" "WRITE-VECTOR" "READ-OCTETS"
           "WRITE-OCTETS" "WRITE-ALL-OCTETS" "WAIT-FOR-INPUT-AVAILABLE"
           "WITH-OPEN-FILE" "WITH-OPEN-STREAM" "FORMAT" "PPRINT" "PRIN1"
           "PRIN1-TO-STRING" "PRINC" "PRINC-TO-STRING" "PRINT" "READ"
           "READ-DELIMITED-LIST" "READ-FROM-STRING" "WRITE" "WRITE-LINE"
           "WRITE-TO-STRING" "READ-PRESERVING-WHITESPACE"
	   
	   "STRING-TO-OCTETS" "OCTETS-TO-STRING" "*DEFAULT-EXTERNAL-FORMAT*"
	   "STRING-ENCODE" "STRING-DECODE"
	   "SET-SYSTEM-EXTERNAL-FORMAT"
	   "+REPLACEMENT-CHARACTER-CODE+"
	   "LIST-ALL-EXTERNAL-FORMATS"
	   "DESCRIBE-EXTERNAL-FORMAT"))

(dolist
    (name
     '("DEBUG-SOURCE" "DEBUG-SOURCE-COMPILED" "DEBUG-SOURCE-CREATED"
       "DEBUG-SOURCE-FROM" "DEBUG-SOURCE-NAME" "DEBUG-SOURCE-P"
       "DEBUG-SOURCE-START-POSITIONS"))
  (intern name "C"))

(defpackage "DEBUG-INTERNALS"
  (:nicknames "DI")
  (:import-from "C" "DEBUG-SOURCE" "DEBUG-SOURCE-COMPILED"
		"DEBUG-SOURCE-CREATED" "DEBUG-SOURCE-FROM" "DEBUG-SOURCE-NAME"
		"DEBUG-SOURCE-P" "DEBUG-SOURCE-START-POSITIONS")
  (:export "*DEBUGGING-INTERPRETER*" "ACTIVATE-BREAKPOINT"
	   "AMBIGUOUS-DEBUG-VARIABLES" "AMBIGUOUS-VARIABLE-NAME" "BREAKPOINT"
	   "BREAKPOINT-ACTIVE-P" "BREAKPOINT-HOOK-FUNCTION" "BREAKPOINT-INFO"
	   "BREAKPOINT-KIND" "BREAKPOINT-P" "BREAKPOINT-WHAT" "CODE-LOCATION"
	   "CODE-LOCATION-DEBUG-BLOCK" "CODE-LOCATION-DEBUG-FUNCTION"
	   "CODE-LOCATION-DEBUG-SOURCE" "CODE-LOCATION-FORM-NUMBER"
	   "CODE-LOCATION-P" "CODE-LOCATION-TOP-LEVEL-FORM-OFFSET"
	   "CODE-LOCATION-UNKNOWN-P" "CODE-LOCATION=" "DEACTIVATE-BREAKPOINT"
	   "DEBUG-BLOCK" "DEBUG-BLOCK-ELSEWHERE-P" "DEBUG-BLOCK-P"
	   "DEBUG-BLOCK-SUCCESSORS" "DEBUG-CONDITION" "DEBUG-ERROR"
	   "DEBUG-FUNCTION" "DEBUG-FUNCTION-FUNCTION" "DEBUG-FUNCTION-KIND"
	   "DEBUG-FUNCTION-LAMBDA-LIST" "DEBUG-FUNCTION-NAME"
	   "DEBUG-FUNCTION-P" "DEBUG-FUNCTION-START-LOCATION"
	   "DEBUG-FUNCTION-SYMBOL-VARIABLES" "DEBUG-SOURCE"
	   "DEBUG-SOURCE-COMPILED" "DEBUG-SOURCE-CREATED" "DEBUG-SOURCE-FROM"
	   "DEBUG-SOURCE-NAME" "DEBUG-SOURCE-P" "DEBUG-SOURCE-ROOT-NUMBER"
	   "DEBUG-SOURCE-START-POSITIONS" "DEBUG-VARIABLE"
	   "DEBUG-VARIABLE-ID" "DEBUG-VARIABLE-INFO-AVAILABLE"
	   "DEBUG-VARIABLE-NAME" "DEBUG-VARIABLE-P" "DEBUG-VARIABLE-PACKAGE"
	   "DEBUG-VARIABLE-SYMBOL" "DEBUG-VARIABLE-VALID-VALUE"
	   "DEBUG-VARIABLE-VALIDITY" "DEBUG-VARIABLE-VALUE"
	   "DELETE-BREAKPOINT" "DELETE-BREAKPOINT-FOR-EDITOR" "DO-BLOCKS"
	   "DO-DEBUG-BLOCK-LOCATIONS" "DO-DEBUG-FUNCTION-BLOCKS"
	   "DO-DEBUG-FUNCTION-VARIABLES" "EVAL-IN-FRAME"
	   "FORM-NUMBER-TRANSLATIONS" "FRAME" "FRAME-CATCHES"
	   "FRAME-CODE-LOCATION" "FRAME-DEBUG-FUNCTION" "FRAME-DOWN"
	   "FRAME-FUNCTION-MISMATCH" "FRAME-NUMBER" "FRAME-P" "FRAME-UP"
	   "FUNCTION-DEBUG-FUNCTION" "FUNCTION-END-COOKIE-VALID-P"
	   "INVALID-CONTROL-STACK-POINTER" "INVALID-VALUE"
	   "LAMBDA-LIST-UNAVAILABLE" "MAKE-BREAKPOINT" "NO-DEBUG-BLOCKS"
	   "NO-DEBUG-FUNCTION-RETURNS" "NO-DEBUG-INFO" "PREPROCESS-FOR-EVAL"
	   "RETURN-FROM-FRAME" "SET-BREAKPOINT-FOR-EDITOR"
	   "SET-LOCATION-BREAKPOINT-FOR-EDITOR" "SOURCE-PATH-CONTEXT"
	   "TOP-FRAME" "UNHANDLED-CONDITION" "UNKNOWN-CODE-LOCATION"
	   "UNKNOWN-CODE-LOCATION-P" "UNKNOWN-DEBUG-VARIABLE"
	   "CODE-LOCATION-KIND" "FLUSH-FRAMES-ABOVE"
	   "FIND-DEBUG-TAG-FOR-FRAME"))
(dolist
    (name
     '("%ARRAY-TYPEP" "%ASET" "%BITSET" "%CHARSET" "%PUT"
       "%RPLACA" "%RPLACD" "%SBITSET" "%SCHARSET"
       "%SET-FDEFINITION" "%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF"
       "%SET-SAP-REF-DESCRIPTOR" "%SETELT" "%SETNTH" "%SP-STRING-COMPARE"
       "%SVSET" "%TYPEP" "SHORT-FLOAT-P"
       "STRING/=*" "STRING<*" "STRING<=*" "STRING=*" "STRING>*" "STRING>=*"))
  (intern name "LISP"))
(dolist
    (name
      '("FOREIGN-SYMBOL-ADDRESS" "FOREIGN-SYMBOL-CODE-ADDRESS"
	"FOREIGN-SYMBOL-DATA-ADDRESS"))
  (intern name "SYSTEM"))

(defpackage "C"
  (:nicknames "COMPILER")
  (:import-from "LISP" "%ARRAY-TYPEP" "%ASET"
		"%BITSET" "%CHARSET" "%PUT" "%RPLACA" "%RPLACD" "%SBITSET"
		"%SCHARSET" "%SET-FDEFINITION"
		"%SET-FILL-POINTER" "%SET-ROW-MAJOR-AREF"
		"%SET-SAP-REF-DESCRIPTOR" "%SETELT" "%SETNTH"
		"%SP-STRING-COMPARE"
		"%SVSET" "%TYPEP" "SHORT-FLOAT-P"
		"STRING/=*" "STRING<*" "STRING<=*" "STRING=*"
		"STRING>*" "STRING>=*")
  (:import-from "SYSTEM" "FOREIGN-SYMBOL-ADDRESS" "FOREIGN-SYMBOL-CODE-ADDRESS"
		"FOREIGN-SYMBOL-DATA-ADDRESS")
  (:import-from "EXTENSIONS"
		"VARIABLE-INFORMATION"
		"FUNCTION-INFORMATION"
		"DECLARATION-INFORMATION"
		"PARSE-MACRO"
		"AUGMENT-ENVIRONMENT")
  (:shadowing-import-from "KERNEL" "CLASS" "BUILT-IN-CLASS" "STANDARD-CLASS"
			  "STRUCTURE-CLASS" "FIND-CLASS" "CLASS-OF")
  (:export "%ALIEN-FUNCALL" "%CATCH-BREAKUP" "%CONTINUE-UNWIND" "&MORE"
	   "%LISTIFY-REST-ARGS" "%MORE-ARG" "%MORE-ARG-VALUES"
	   "%UNWIND-PROTECT-BREAKUP"
	   "*BACKEND*" "*CODE-SEGMENT*" "*COLLECT-DYNAMIC-STATISTICS*"
	   "*COMPILE-TIME-DEFINE-MACROS*" "*COMPILER-NOTIFICATION-FUNCTION*"
	   "*COMPILING-FOR-INTERPRETER*" "*CONVERTING-FOR-INTERPRETER*"
	   "*COUNT-VOP-USAGES*" "*ELSEWHERE*" "*NATIVE-BACKEND*"
	   "*SUPPRESS-VALUES-DECLARATION*" "*TARGET-BACKEND*"
	   "ALLOC-ALIEN-STACK-SPACE"
	   "ALLOC-NUMBER-STACK-SPACE" "ALLOCATE-CODE-OBJECT" "ALLOCATE-FRAME"
 	   "ALLOCATE-DYNAMIC-CODE-OBJECT"
	   "ALLOCATE-FULL-CALL-FRAME" "ANY" "ARGUMENT-COUNT-ERROR"
	   "ATTRIBUTES" "ATTRIBUTES-INTERSECTION" "ATTRIBUTES-UNION"
	   "ATTRIBUTES=" "BACKEND-ANY-PRIMITIVE-TYPE"
	   "BACKEND-ASSEMBLER-RESOURCES" "BACKEND-BYTE-ORDER"
	   "BACKEND-DISASSEM-PARAMS" "BACKEND-FASL-FILE-IMPLEMENTATION"
	   "BACKEND-FASL-FILE-TYPE" "BACKEND-FASL-FILE-VERSION"
	   "BACKEND-FEATURES"
	   "BACKEND-FOREIGN-LINKAGE-SPACE-START"
	   "BACKEND-FOREIGN-LINKAGE-ENTRY-SIZE"
	   "BACKEND-INFO-ENVIRONMENT"
	   "BACKEND-INSTRUCTION-FLAVORS" "BACKEND-INSTRUCTION-FORMATS"
	   "BACKEND-NAME" "BACKEND-REGISTER-SAVE-PENALTY"
	   "BACKEND-SPECIAL-ARG-TYPES" "BACKEND-VERSION" "BIND" "BRANCH"
	   "CALL" "CALL-LOCAL" "CALL-NAMED" "CALL-OUT" "CALL-VARIABLE"
	   "CALLEE-NFP-TN" "CALLEE-RETURN-PC-TN" "CATCH-BLOCK" "CHECK-CONS"
	   "CHECK-FIXNUM" "CHECK-FUNCTION" "CHECK-FUNCTION-OR-SYMBOL"
	   "CHECK-BIGNUM" "CHECK-SIGNED-BYTE-32" "CHECK-SYMBOL"
	   "CHECK-UNSIGNED-BYTE-32"
	   "CLOSURE-INIT" "CLOSURE-REF" "CODE-CONSTANT-REF"
	   "CODE-CONSTANT-SET" "CODE-INSTRUCTIONS" "COERCE-TO-FUNCTION"
	   "COMPILE-FOR-EVAL" "COMPONENT" "COMPONENT-HEADER-LENGTH"
	   "COMPONENT-INFO" "COMPONENT-LIVE-TN" "COMPUTE-FUNCTION"
	   "COMPUTE-OLD-NFP" "COPY-MORE-ARG" "COUNT-ME"
	   "CURRENT-BINDING-POINTER" "CURRENT-NFP-TN" "CURRENT-STACK-POINTER"
	   "DEALLOC-ALIEN-STACK-SPACE"
	   "DEALLOC-NUMBER-STACK-SPACE" "DEF-BOOLEAN-ATTRIBUTE"
	   "DEF-IR1-TRANSLATOR" "DEF-PRIMITIVE-TRANSLATOR"
	   "DEF-PRIMITIVE-TYPE" "DEF-PRIMITIVE-TYPE-ALIAS"
	   "DEF-SOURCE-TRANSFORM" "DEF-VM-SUPPORT-ROUTINE"
	   "DEFINE-ASSEMBLY-ROUTINE" "DEFINE-MOVE-FUNCTION" "DEFINE-MOVE-VOP"
	   "DEFINE-STORAGE-BASE" "DEFINE-STORAGE-CLASS" "DEFINE-VOP"
	   "DEFKNOWN" "DEFOPTIMIZER" "DEFTRANSFORM" "DERIVE-TYPE"
	   "ENTRY-NODE-INFO-NLX-TAG" "ENTRY-NODE-INFO-ST-TOP"
	   "ENVIRONMENT-DEBUG-LIVE-TN" "ENVIRONMENT-LIVE-TN"
	   "FASL-FILE-IMPLEMENTATIONS" "FAST-SAFE-COERCE-TO-FUNCTION"
	   "FAST-SYMBOL-FUNCTION" "FAST-SYMBOL-VALUE"
	   "FLUSHABLE" "FOLDABLE"
	   "FORCE-TN-TO-STACK" "FOREIGN-SYMBOL-ADDRESS"
	   "FOREIGN-SYMBOL-CODE-ADDRESS" "FOREIGN-SYMBOL-DATA-ADDRESS"
	   "GET-VECTOR-SUBTYPE"
	   "HALT" "IF-EQ" "INSTANCE-REF" "INSTANCE-SET"
	   "IR2-COMPONENT-CONSTANTS" "IR2-CONVERT"
	   "IR2-ENVIRONMENT-NUMBER-STACK-P" "KNOWN-CALL-LOCAL" "KNOWN-RETURN"
	   "LAMBDA-EVAL-INFO-ARGS-PASSED" "LAMBDA-EVAL-INFO-ENTRIES"
	   "LAMBDA-EVAL-INFO-FRAME-SIZE" "LAMBDA-EVAL-INFO-FUNCTION"
	   "LOCATION=" "LTN-ANNOTATE" "MAKE-ALIAS-TN" "MAKE-CATCH-BLOCK"
	   "MAKE-CLOSURE" "MAKE-CONSTANT-TN" "MAKE-FIXNUM"
	   "MAKE-LOAD-TIME-CONSTANT-TN" "MAKE-N-TNS" "MAKE-NORMAL-TN"
	   "MAKE-OTHER-IMMEDIATE-TYPE" "MAKE-RANDOM-TN"
	   "MAKE-REPRESENTATION-TN" "MAKE-RESTRICTED-TN" "MAKE-SC-OFFSET"
	   "MAKE-STACK-POINTER-TN" "MAKE-TN-REF" "MAKE-UNWIND-BLOCK"
	   "MAKE-VALUE-CELL" "MAKE-WIRED-TN" "META-PRIMITIVE-TYPE-OR-LOSE"
	   "META-SB-OR-LOSE" "META-SC-NUMBER-OR-LOSE" "META-SC-OR-LOSE"
	   "MORE-ARG-CONTEXT" "MOVABLE" "MOVE" "MULTIPLE-CALL"
	   "MULTIPLE-CALL-LOCAL" "MULTIPLE-CALL-NAMED"
	   "MULTIPLE-CALL-VARIABLE" "NIL" "NLX-ENTRY" "NLX-ENTRY-MULTIPLE"
	   "NON-DESCRIPTOR-STACK" "NOTE-ENVIRONMENT-START"
	   "NOTE-THIS-LOCATION" "OPTIMIZER"
	   "PACK-TRACE-TABLE" "PMAX-FASL-FILE-IMPLEMENTATION" "POLICY"
	   "PPC-FASL-FILE-IMPLEMENTATION"
	   "PREDICATE" "PRIMITIVE-TYPE" "PRIMITIVE-TYPE-OF"
	   "PRIMITIVE-TYPE-OR-LOSE" "PRIMITIVE-TYPE-VOP" "PUSH-VALUES"
	   "READ-PACKED-BIT-VECTOR" "READ-VAR-INTEGER" "READ-VAR-STRING"
           "*RECORD-XREF-INFO*"
	   "RESET-STACK-POINTER" "RESTORE-DYNAMIC-STATE" "RETURN"
	   "RETURN-MULTIPLE" "RT-AFPA-FASL-FILE-IMPLEMENTATION"
	   "RT-FASL-FILE-IMPLEMENTATION" "SAVE-DYNAMIC-STATE" "SB"
	   "SB-ALLOCATED-SIZE" "SB-NAME" "SB-OR-LOSE" "SB-P" "SC" "SC-CASE"
	   "SC-IS" "SC-NAME" "SC-NUMBER" "SC-NUMBER-OR-LOSE"
	   "SC-OFFSET-OFFSET" "SC-OFFSET-SCN" "SC-OR-LOSE" "SC-P" "SC-SB"
	   "SET" "SET-UNWIND-PROTECT" "SET-VECTOR-SUBTYPE"
	   "SETUP-CLOSURE-ENVIRONMENT" "SETUP-ENVIRONMENT"
	   "SPARC-FASL-FILE-IMPLEMENTATION" "SPECIFY-SAVE-TN" "INSTANCE-REF"
	   "INSTANCE-SET" "SXHASH-SIMPLE-STRING" "SXHASH-SIMPLE-SUBSTRING"
	   "SYMBOL-FUNCTION" "SYMBOL-VALUE" "SYMBOLICATE" "TAIL-CALL"
	   "TAIL-CALL-NAMED" "TAIL-CALL-VARIABLE" "TEMPLATE-OR-LOSE" "THROW"
	   "TN" "TN-OFFSET" "TN-P" "TN-REF" "TN-REF-ACROSS" "TN-REF-LOAD-TN"
	   "TN-REF-NEXT" "TN-REF-NEXT-REF" "TN-REF-P" "TN-REF-TARGET"
	   "TN-REF-TN" "TN-REF-VOP" "TN-REF-WRITE-P" "TN-SC" "TN-VALUE"
	   "TRACE-TABLE-ENTRY" "TYPE-CHECK-ERROR" "UNBIND" "UNBIND-TO-HERE"
	   "UNSAFE" "UNWIND" "UWP-ENTRY"
	   "VALUE-CELL-REF" "VALUE-CELL-SET" "VALUES-LIST"
	   "VERIFY-ARGUMENT-COUNT" "WRITE-PACKED-BIT-VECTOR"
	   "WRITE-VAR-INTEGER" "WRITE-VAR-STRING" "XEP-ALLOCATE-FRAME"
	   "LABEL-ID" "FIXUP" "FIXUP-FLAVOR" "FIXUP-NAME" "FIXUP-OFFSET"
	   "FIXUP-P" "MAKE-FIXUP"
	   "SLOT"
	   "X86-FASL-FILE-IMPLEMENTATION"
	   "BACKEND-FEATUREP"
	   "DEF-ALLOC"
	   "BACKEND-ASSEMBLER-PARAMS"
	   "VAR-ALLOC"
	   "BACKEND-INTERNAL-ERRORS"
	   "BACKEND"
	   "SAFE-FDEFN-FUNCTION"
	   "NOTE-FIXUP"
	   "TARGET-FEATUREP"
	   "DEF-REFFER"
	   "NATIVE-FEATUREP"
	   "EMIT-NOP"
	   "DEF-SETTER"
	   "FIXED-ALLOC"
	   "HPPA-FASL-FILE-IMPLEMENTATION"
	   "ALPHA-FASL-FILE-IMPLEMENTATION"
	   "SGI-FASL-FILE-IMPLEMENTATION"
	   "AMD64-FASL-FILE-IMPLEMENTATION"
	   "MAKE-UNBOUND-MARKER"
	   "RETURN-SINGLE"
	   "BACKEND-PAGE-SIZE"
	   "NOTE-NEXT-INSTRUCTION"
	   "SET-SLOT"
	   "LOCATION-NUMBER"
	   "BYTE-FASL-FILE-VERSION"
	   "*COMPILE-COMPONENT*"
	   "BLOCK-NUMBER"
	   "DYNCOUNT-INFO-COUNTS"
	   "BACKEND-BYTE-FASL-FILE-IMPLEMENTATION"
	   "IR2-BLOCK-BLOCK"
	   "DISASSEM-BYTE-COMPONENT"
	   "LITTLE-ENDIAN-FASL-FILE-IMPLEMENTATION"
	   "DYNCOUNT-INFO-COSTS"
	   "FUNCALLABLE-INSTANCE-LEXENV"
	   "DISASSEM-BYTE-FUN"
	   "VOP-BLOCK"
	   "BACKEND-BYTE-FASL-FILE-TYPE"
	   "BIG-ENDIAN-FASL-FILE-IMPLEMENTATION"
	   "*ASSEMBLY-OPTIMIZE*"
	   "LARGE-ALLOC"
	   "%SET-FUNCTION-SELF"
	   "IR2-COMPONENT-DYNCOUNT-INFO"
	   "DYNCOUNT-INFO" "DYNCOUNT-INFO-P"
	   "TRUST-DYNAMIC-EXTENT-DECLARATION-P"
	   "IR2-STACK-ALLOCATE"
	   "%DYNAMIC-EXTENT" "%DYNAMIC-EXTENT-START" "%DYNAMIC-EXTENT-END")
  )
(defpackage "XREF"
  (:export "INIT-XREF-DATABASE"
           "REGISTER-XREF"
           "WHO-CALLS"
           "WHO-REFERENCES"
           "WHO-BINDS"
           "WHO-SETS"
           "WHO-SUBCLASSES"
           "WHO-SUPERCLASSES"
           "WHO-SPECIALIZES"
           "WHO-MACROEXPANDS"
           "MAKE-XREF-CONTEXT"
           "XREF-CONTEXT-NAME"
           "XREF-CONTEXT-FILE"
           "XREF-CONTEXT-SOURCE-PATH"
	   "INVALIDATE-XREFS-FOR-NAMESTRING"
	   "FIND-XREFS-FOR-PATHNAME"))

(defpackage "WIRE"
  (:export "*CURRENT-WIRE*" "CONNECT-TO-REMOTE-SERVER"
	   "CREATE-REQUEST-SERVER" "DESTROY-REQUEST-SERVER"
	   "FORGET-REMOTE-TRANSLATION" "MAKE-REMOTE-OBJECT" "MAKE-WIRE"
	   "REMOTE" "REMOTE-OBJECT" "REMOTE-OBJECT-EQ"
	   "REMOTE-OBJECT-LOCAL-P" "REMOTE-OBJECT-P" "REMOTE-OBJECT-VALUE"
	   "REMOTE-VALUE" "REMOTE-VALUE-BIND" "WIRE-EOF" "WIRE-ERROR"
	   "WIRE-FD" "WIRE-FORCE-OUTPUT" "WIRE-GET-BIGNUM" "WIRE-GET-BYTE"
	   "WIRE-GET-NUMBER" "WIRE-GET-OBJECT" "WIRE-GET-STRING"
	   "WIRE-IO-ERROR" "WIRE-LISTEN" "WIRE-OUTPUT-BIGNUM"
	   "WIRE-OUTPUT-BYTE" "WIRE-OUTPUT-FUNCALL" "WIRE-OUTPUT-NUMBER"
	   "WIRE-OUTPUT-OBJECT" "WIRE-OUTPUT-STRING" "WIRE-P"))

(defpackage "PRETTY-PRINT"
  (:nicknames "PP")
  (:export "PRETTY-STREAM" "PRETTY-STREAM-P"))

(intern "LOAD-FOREIGN" "EXTENSIONS")
(defpackage "SYSTEM"
  (:nicknames "SYS")
  (:import-from "EXTENSIONS" "LOAD-FOREIGN")
  (:export "%ASSEMBLER-CODE-TYPE" "%BIND-ALIGNED-SAP" "%PRIMITIVE"
	   "%SP-BYTE-BLT" "%SP-FIND-CHARACTER"
	   "%SP-FIND-CHARACTER-WITH-ATTRIBUTE"
	   "%SP-REVERSE-FIND-CHARACTER-WITH-ATTRIBUTE" "%STANDARD-CHAR-P"
	   "*BEEP-FUNCTION*"
	   "*LONG-SITE-NAME*" "*SHORT-SITE-NAME*"
	   "*SOFTWARE-TYPE*" "*STDERR*" "*STDIN*" "*STDOUT*" "*TASK-DATA*"
	   "*TASK-NOTIFY*" "*TASK-SELF*" "*TTY*" "*TYPESCRIPTPORT*"
	   "*XWINDOW-TABLE*"
	   "ADD-FD-HANDLER" "ADD-PORT-DEATH-HANDLER" "ADD-PORT-OBJECT"
	   "ADD-XWINDOW-OBJECT" "ALLOCATE-SYSTEM-MEMORY" "BEEP" "BITS"
	   "BYTES" "C-PROCEDURE" "CHECK<=" "CHECK=" "COMPILER-VERSION"
	   "CT-A-VAL" "CT-A-VAL-OFFSET" "CT-A-VAL-P" "CT-A-VAL-SAP"
	   "CT-A-VAL-SIZE" "CT-A-VAL-TYPE" "DEALLOCATE-SYSTEM-MEMORY"
	   "DEFAULT-INTERRUPT"
	   "DEPORT-BOOLEAN" "DEPORT-INTEGER" "DOUBLE-FLOAT-RADIX"
	   "ENABLE-INTERRUPT" "ENUMERATION" "FD-STREAM" "FD-STREAM-FD"
	   "FD-STREAM-P" "FIND-IF-IN-CLOSURE" "FOREIGN-SYMBOL-ADDRESS"
	   "FOREIGN-SYMBOL-CODE-ADDRESS" "FOREIGN-SYMBOL-DATA-ADDRESS"
	   "GET-PAGE-SIZE" "GET-SYSTEM-INFO"
	   "IGNORE-INTERRUPT"
	   "INT-SAP" "INVALIDATE-DESCRIPTOR" "IO-TIMEOUT"
	   "LISP-STREAM" "LONG-FLOAT-RADIX" "LONG-WORDS"
	   "MACRO" "MAKE-CT-A-VAL" "MAKE-FD-STREAM"
	   "MAKE-INDENTING-STREAM" "INDENTING-STREAM-P"
           "MAKE-OBJECT-SET" "MAP-PORT" "MAP-XWINDOW"
	   "NATURALIZE-BOOLEAN" "NATURALIZE-INTEGER" "NULL-TERMINATED-STRING"
	   "OBJECT-SET-OPERATION" "OUTPUT-RAW-BYTES" "PARSE-BODY"
	   "PERQ-STRING" "POINTER" "POINTER<" "POINTER>" "PORT" "PRIMEP"
	   "READ-N-BYTES" "REALLOCATE-SYSTEM-MEMORY" "RECORD-SIZE"
	   "REMOVE-FD-HANDLER" "REMOVE-PORT-DEATH-HANDLER"
	   "REMOVE-PORT-OBJECT" "REMOVE-XWINDOW-OBJECT"
	   "RESOLVE-LOADED-ASSEMBLER-REFERENCES" "SAP+" "SAP-" "SAP-INT"
	   "SAP-REF-16" "SAP-REF-32" "SAP-REF-64" "SAP-REF-8"
	   "SAP-REF-DESCRIPTOR"
	   "SAP-REF-DOUBLE" "SAP-REF-LONG" "SAP-REF-SAP" "SAP-REF-SINGLE"
	   "SAP<" "SAP<=" "SAP=" "SAP>" "SAP>="
	   "SCRUB-CONTROL-STACK" "SERVE-ALL-EVENTS"
	   "SERVE-EVENT" "SERVER" "SERVER-MESSAGE" "SHORT-FLOAT-RADIX"
	   "SIGNED-SAP-REF-16" "SIGNED-SAP-REF-32"
	   "SIGNED-SAP-REF-64" "SIGNED-SAP-REF-8"
	   "SINGLE-FLOAT-RADIX" "SYMBOL-MACRO-LET" "SYSTEM-AREA-POINTER"
	   "SYSTEM-AREA-POINTER-P" "VECTOR-SAP"
	   "WAIT-UNTIL-FD-USABLE" "WITH-ENABLED-INTERRUPTS" "WITH-FD-HANDLER"
	   "WITH-INTERRUPTS" "WITH-REPLY-PORT" "WITHOUT-GCING"
	   "WITHOUT-HEMLOCK" "WITHOUT-INTERRUPTS" "WORDS"
	   "OS-INIT" "ALLOCATE-SYSTEM-MEMORY-AT"
	   "ALTERNATE-GET-GLOBAL-ADDRESS"
	   "*RUNTIME-FEATURES*" "REGISTER-LISP-FEATURE"
	   "REGISTER-LISP-RUNTIME-FEATURE"

	   "BINARY-TEXT-STREAM"))

(dolist
    (name
     '("*" "ARRAY" "BOOLEAN" "DOUBLE-FLOAT" "FUNCTION" "INTEGER" "LONG-FLOAT"
       "SINGLE-FLOAT" "UNION" "VALUES"
       ))
  (intern name "LISP"))

(defpackage "ALIEN"
  (:import-from "LISP" "*" "ARRAY" "DOUBLE-FLOAT" "FUNCTION"
		"BOOLEAN" "INTEGER" "LONG-FLOAT" "SINGLE-FLOAT" "UNION" "VALUES")
  (:export "*" "ADDR" "ALIEN" "ALIEN-FUNCALL" "ALIEN-SAP"
	   "ALIEN-SIZE" "ARRAY" "BOOLEAN" "CAST" "DEF-ALIEN-ROUTINE"
	   "DEF-ALIEN-TYPE" "DEF-ALIEN-VARIABLE" "DEF-BUILTIN-ALIEN-TYPE"
	   "DEREF" "DOUBLE-FLOAT" "ENUM" "EXTERN-ALIEN" "FUNCTION" "INTEGER"
	   "LONG-FLOAT" "SAP-ALIEN" "SIGNED" "SINGLE-FLOAT" "SLOT" "STRUCT"
	   "UNION" "UNSIGNED" "VALUES" "WITH-ALIEN" "FREE-ALIEN" "NULL-ALIEN"
	   "MAKE-ALIEN" "LOAD-FOREIGN" "SYSTEM-AREA-POINTER"
	   "DEF-CALLBACK" "CALLBACK" "CALLBACK-FUNCALL"))

(dolist
    (name
     '("%CAST" "%DEREF-ADDR" "%HEAP-ALIEN" "%HEAP-ALIEN-ADDR"
       "%LOCAL-ALIEN-ADDR" "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN"
       "%SET-DEREF" "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT"
       "%SLOT-ADDR" "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
       "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
       "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
       "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
       "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
       "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
       "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
       "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
       "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
       "ALIEN-LONG-FLOAT-TYPE" "ALIEN-LONG-FLOAT-TYPE-P"
       "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P" "ALIEN-POINTER-TYPE-TO"
       "ALIEN-RECORD-FIELD" "ALIEN-RECORD-FIELD-NAME"
       "ALIEN-RECORD-FIELD-OFFSET" "ALIEN-RECORD-FIELD-P"
       "ALIEN-RECORD-FIELD-TYPE" "ALIEN-RECORD-TYPE"
       "ALIEN-RECORD-TYPE-FIELDS" "ALIEN-RECORD-TYPE-P"
       "ALIEN-SINGLE-FLOAT-TYPE" "ALIEN-SINGLE-FLOAT-TYPE-P"
       "ALIEN-SUBTYPE-P" "ALIEN-TYPE" "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT"
       "ALIEN-TYPE-BITS" "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE"
       "ALIEN-VALUE-TYPE" "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
       "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
       "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
       "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
       "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
       "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
       "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
       "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
       "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
       "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
       "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
       "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
       "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
       "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE"))
  (intern name "ALIEN"))

(defpackage "ALIEN-INTERNALS"
  (:import-from "ALIEN" "%CAST" "%DEREF-ADDR" "%HEAP-ALIEN"
		"%HEAP-ALIEN-ADDR" "%LOCAL-ALIEN-ADDR"
		"%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN" "%SET-DEREF"
		"%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT" "%SLOT-ADDR"
		"*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
		"ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
		"ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
		"ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
		"ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
		"ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
		"ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
		"ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
		"ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
		"ALIEN-LONG-FLOAT-TYPE" "ALIEN-LONG-FLOAT-TYPE-P"
		"ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P"
		"ALIEN-POINTER-TYPE-TO" "ALIEN-RECORD-FIELD"
		"ALIEN-RECORD-FIELD-NAME" "ALIEN-RECORD-FIELD-OFFSET"
		"ALIEN-RECORD-FIELD-P" "ALIEN-RECORD-FIELD-TYPE"
		"ALIEN-RECORD-TYPE" "ALIEN-RECORD-TYPE-FIELDS"
		"ALIEN-RECORD-TYPE-P" "ALIEN-SINGLE-FLOAT-TYPE"
		"ALIEN-SINGLE-FLOAT-TYPE-P" "ALIEN-SUBTYPE-P" "ALIEN-TYPE"
		"ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT" "ALIEN-TYPE-BITS"
		"ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE" "ALIEN-VALUE-TYPE"
		"ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
		"ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
		"COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
		"COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
		"COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
		"DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
		"DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
		"HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
		"HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
		"LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
		"LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
		"MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
		"MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
		"PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE")
  (:export "%CAST" "%DEREF-ADDR" "%HEAP-ALIEN" "%HEAP-ALIEN-ADDR"
	   "%LOCAL-ALIEN-ADDR" "%LOCAL-ALIEN-FORCED-TO-MEMORY-P" "%SAP-ALIEN"
	   "%SET-DEREF" "%SET-HEAP-ALIEN" "%SET-LOCAL-ALIEN" "%SET-SLOT"
	   "%SLOT-ADDR" "*VALUES-TYPE-OKAY*" "ALIEN" "ALIEN-ARRAY-TYPE"
	   "ALIEN-ARRAY-TYPE-DIMENSIONS" "ALIEN-ARRAY-TYPE-ELEMENT-TYPE"
	   "ALIEN-ARRAY-TYPE-P" "ALIEN-BOOLEAN-TYPE" "ALIEN-BOOLEAN-TYPE-P"
	   "ALIEN-DOUBLE-FLOAT-TYPE" "ALIEN-DOUBLE-FLOAT-TYPE-P"
	   "ALIEN-ENUM-TYPE" "ALIEN-ENUM-TYPE-P" "ALIEN-FLOAT-TYPE"
	   "ALIEN-FLOAT-TYPE-P" "ALIEN-FUNCTION-TYPE"
	   "ALIEN-FUNCTION-TYPE-ARG-TYPES" "ALIEN-FUNCTION-TYPE-P"
	   "ALIEN-FUNCTION-TYPE-RESULT-TYPE" "ALIEN-INTEGER-TYPE"
	   "ALIEN-INTEGER-TYPE-P" "ALIEN-INTEGER-TYPE-SIGNED"
	   "ALIEN-LONG-FLOAT-TYPE" "ALIEN-LONG-FLOAT-TYPE-P"
	   "ALIEN-POINTER-TYPE" "ALIEN-POINTER-TYPE-P"
	   "ALIEN-POINTER-TYPE-TO" "ALIEN-RECORD-FIELD"
	   "ALIEN-RECORD-FIELD-NAME" "ALIEN-RECORD-FIELD-OFFSET"
	   "ALIEN-RECORD-FIELD-P" "ALIEN-RECORD-FIELD-TYPE"
	   "ALIEN-RECORD-TYPE" "ALIEN-RECORD-TYPE-FIELDS"
	   "ALIEN-RECORD-TYPE-P" "ALIEN-SINGLE-FLOAT-TYPE"
	   "ALIEN-SINGLE-FLOAT-TYPE-P" "ALIEN-SUBTYPE-P" "ALIEN-TYPE"
	   "ALIEN-TYPE-=" "ALIEN-TYPE-ALIGNMENT" "ALIEN-TYPE-BITS"
	   "ALIEN-TYPE-P" "ALIEN-TYPEP" "ALIEN-VALUE" "ALIEN-VALUE-TYPE"
	   "ALIEN-VALUES-TYPE" "ALIEN-VALUES-TYPE-P"
	   "ALIEN-VALUES-TYPE-VALUES" "ALIGN-OFFSET" "COMPUTE-ALIEN-REP-TYPE"
	   "COMPUTE-DEPORT-LAMBDA" "COMPUTE-DEPOSIT-LAMBDA"
	   "COMPUTE-EXTRACT-LAMBDA" "COMPUTE-LISP-REP-TYPE"
	   "COMPUTE-NATURALIZE-LAMBDA" "DEF-ALIEN-TYPE-CLASS"
	   "DEF-ALIEN-TYPE-METHOD" "DEF-ALIEN-TYPE-TRANSLATOR" "DEPORT"
	   "DEPOSIT-ALIEN-VALUE" "DISPOSE-LOCAL-ALIEN" "EXTRACT-ALIEN-VALUE"
	   "HEAP-ALIEN-INFO" "HEAP-ALIEN-INFO-P" "HEAP-ALIEN-INFO-SAP-FORM"
	   "HEAP-ALIEN-INFO-TYPE" "INVOKE-ALIEN-TYPE-METHOD" "LOCAL-ALIEN"
	   "LOCAL-ALIEN-INFO" "LOCAL-ALIEN-INFO-FORCE-TO-MEMORY-P"
	   "LOCAL-ALIEN-INFO-P" "LOCAL-ALIEN-INFO-TYPE"
	   "MAKE-ALIEN-FUNCTION-TYPE" "MAKE-ALIEN-POINTER-TYPE"
	   "MAKE-LOCAL-ALIEN" "NATURALIZE" "NOTE-LOCAL-ALIEN-TYPE"
	   "PARSE-ALIEN-TYPE" "UNPARSE-ALIEN-TYPE"))

(defpackage "PROFILE"
  (:export
   "*DEFAULT-REPORT-TIME-PRINTFUNCTION*" "*INSERT-SPACEREPORTS*"
   "*TIMED-FUNCTIONS*" "DELETE-SPACEREPORTS" "PRINT-SPACEREPORTS"
   "PROFILE" "PROFILE-ALL" "REPORT-TIME" "REPORT-TIME-CUSTOM"
   "RESET-SPACEREPORTS" "RESET-TIME" "UNPROFILE" "WITH-SPACEREPORT"
   "*NO-CALLS-LIMIT*" "*NO-CALLS*"))

(dolist
    (name
     '("ARRAY-RANK" "ARRAY-TOTAL-SIZE" "BOOLEAN" "CHAR-INT" "FLOAT-DIGITS"
       "FLOAT-RADIX" "PATHNAME-DEVICE" "PATHNAME-DIRECTORY" "PATHNAME-HOST"
       "PATHNAME-NAME" "PATHNAME-TYPE" "PATHNAME-VERSION"))
  (intern name "LISP"))
(intern "VOID" "C-CALL")

(defpackage "KERNEL"
  (:import-from "LISP" "BOOLEAN")
  (:import-from "C-CALL" "VOID")
  (:import-from "CONDITIONS" "PARSE-UNKNOWN-TYPE-SPECIFIER")
  (:shadow "CLASS" "STRUCTURE-CLASS" "BUILT-IN-CLASS" "STANDARD-CLASS"
           "FIND-CLASS" "CLASS-OF")
  (:export "%CLASS-LAYOUT" "%CLASS-STATE" "%CLASS-DIRECT-SUPERCLASSES"
	   "%CLASS-SUBCLASSES" "%CLASS-PCL-CLASS" "%CLASS-NAME"
	   "RED-ZONE-HIT" "YELLOW-ZONE-HIT" "STACK-OVERFLOW"
	   "*ANSI-DEFSTRUCT-OPTIONS-P*"
	   "%ACOS" "%ACOSH" "%ARRAY-AVAILABLE-ELEMENTS"
	   "%ARRAY-DATA-VECTOR" "%ARRAY-DIMENSION" "%ARRAY-DISPLACED-P"
	   "%ARRAY-DISPLACEMENT" "%ARRAY-FILL-POINTER"
	   "%ARRAY-FILL-POINTER-P" "%ASIN" "%ASINH" "%ATAN" "%ATAN2" "%ATANH"
	   "%CALLER-FRAME-AND-PC" "%CHECK-BOUND" "%CLOSURE-FUNCTION"
	   "%CLOSURE-INDEX-REF" "%COS" "%COSH" "%DEPOSIT-FIELD"
	   "%DOUBLE-FLOAT" "%DPB" "%EXP" "%EXPM1" "%HYPOT" "%LDB"
	   "%LOG" "%LOGB" "%LOG10" "%LOG1P" "%LOG2" "%LONG-FLOAT"
	   "%MAKE-COMPLEX" "%MAKE-FUNCALLABLE-INSTANCE" "%MAKE-RATIO"
	   "%MASK-FIELD" "%NEGATE" "%POW"
	   "%RAW-BITS" "%RAW-REF-COMPLEX-DOUBLE" "%RAW-REF-COMPLEX-LONG"
	   "%RAW-REF-COMPLEX-SINGLE" "%RAW-REF-DOUBLE" "%RAW-REF-LONG"
	   "%RAW-REF-SINGLE" "%RAW-SET-COMPLEX-DOUBLE"
	   "%RAW-SET-COMPLEX-LONG" "%RAW-SET-COMPLEX-SINGLE"
	   "%RAW-SET-DOUBLE" "%RAW-SET-LONG" "%RAW-SET-SINGLE"
	   "%SCALB" "%SCALBN" "%SET-FUNCALLABLE-INSTANCE-FUNCTION"
	   "%SET-FUNCALLABLE-INSTANCE-INFO" "%SET-RAW-BITS"
	   "%SET-SAP-REF-16" "%SET-SAP-REF-32" "%SET-SAP-REF-64"
	   "%SET-SAP-REF-8" "%SET-SAP-REF-DOUBLE" "%SET-SAP-REF-LONG"
	   "%SET-SAP-REF-SAP" "%SET-SAP-REF-SINGLE"
	   "%SET-SIGNED-SAP-REF-16" "%SET-SIGNED-SAP-REF-32"
	   "%SET-SIGNED-SAP-REF-64" "%SET-SIGNED-SAP-REF-8" 
	   "%SET-STACK-REF" "%SIN" "%SET-SYMBOL-HASH"
	   "%SINGLE-FLOAT" "%SINH" "%SP-SET-DEFINITION" "%SP-SET-PLIST"
	   "%SQRT" "%SXHASH-SIMPLE-STRING" "%SXHASH-SIMPLE-SUBSTRING" "%TAN"
	   "%TANH" "%UNARY-ROUND"
	   "%UNARY-FROUND/SINGLE-FLOAT" "%UNARY-FROUND/DOUBLE-FLOAT"
	   "%UNARY-TRUNCATE" "%UNARY-FTRUNCATE"
	   "%UNARY-FTRUNCATE/SINGLE-FLOAT" "%UNARY-FTRUNCATE/DOUBLE-FLOAT"
	   "%WITH-ARRAY-DATA"
	   "*CURRENT-LEVEL*" "*EMPTY-TYPE*" "*EVAL-STACK-TOP*" "*NULL-TYPE*"
	   "*PRETTY-PRINTER*" "*UNIVERSAL-TYPE*"
	   "*UNPARSE-FUNCTION-TYPE-SIMPLIFY*" "*WILD-TYPE*"
	   "32BIT-LOGICAL-AND" "32BIT-LOGICAL-ANDC1" "32BIT-LOGICAL-ANDC2"
	   "32BIT-LOGICAL-EQV" "32BIT-LOGICAL-NAND" "32BIT-LOGICAL-NOR"
	   "32BIT-LOGICAL-NOT" "32BIT-LOGICAL-OR" "32BIT-LOGICAL-ORC1"
	   "32BIT-LOGICAL-ORC2" "32BIT-LOGICAL-XOR" "ALIEN-TYPE-TYPE"
	   "ALIEN-TYPE-TYPE-ALIEN-TYPE" "ALIEN-TYPE-TYPE-P" "ALLOCATE-VECTOR"
	   "ALWAYS-SUBTYPEP" "ARGS-TYPE" "ARGS-TYPE-ALLOWP" "ARGS-TYPE-KEYP"
	   "ARGS-TYPE-KEYWORDS" "ARGS-TYPE-OPTIONAL" "ARGS-TYPE-P"
	   "ARGS-TYPE-REQUIRED" "ARGS-TYPE-REST" "ARRAY-HEADER-P"
	   "ARRAY-RANK" "ARRAY-TOTAL-SIZE" "ARRAY-TYPE" "ARRAY-TYPE-COMPLEXP"
	   "ARRAY-TYPE-DIMENSIONS" "ARRAY-TYPE-ELEMENT-TYPE" "ARRAY-TYPE-P"
	   "ARRAY-TYPE-SPECIALIZED-ELEMENT-TYPE" "ASH-INDEX" "BASE-CHAR-P"
	   "BINDING-STACK-POINTER-SAP" "BIT-BASH-COPY" "BIT-INDEX"
	   "BYTE-BASH-COPY"
	   "BOGUS-ARGUMENT-TO-VALUES-LIST-ERROR" "BOOLE-CODE"
	   "BOOLEAN" "BYTE-SPECIFIER" "CALLABLE" "CHAR-INT"
	   "SEQUENCE-COUNT"
	   "CHECK-FOR-CIRCULARITY" "CODE-COMPONENT" "CODE-COMPONENT-P"
	   "CODE-DEBUG-INFO" "CODE-HEADER-REF" "CODE-HEADER-SET"
	   "CODE-INSTRUCTIONS" "COMPLEX-DOUBLE-FLOAT-P" "COMPLEX-FLOAT-P"
	   "COMPLEX-LONG-FLOAT-P" "COMPLEX-RATIONAL-P" "COMPLEX-SINGLE-FLOAT-P"
	   "CONSED-SEQUENCE" "CONSTANT-MODIFIED" "CONSTANT-TYPE"
	   "CONSTANT-TYPE-P" "CONSTANT-TYPE-TYPE"
	   "CONS-TYPE" "CONS-TYPE-CAR-TYPE" "CONS-TYPE-CDR-TYPE" "CONS-TYPE-P"
	   "CONTAINING-INTEGER-TYPE"
	   "CONTROL-STACK-POINTER-SAP" "COPY-FROM-SYSTEM-AREA"
	   "COPY-NUMERIC-TYPE" "COPY-TO-SYSTEM-AREA" "CSUBTYPEP" "CTYPE"
	   "CTYPE-OF" "CTYPE-P" "CTYPEP" "CURRENT-FP" "CURRENT-SP"
	   "DATA-VECTOR-REF" "DATA-VECTOR-SET" "DECODE-DOUBLE-FLOAT"
	   "DECODE-LONG-FLOAT" "DECODE-SINGLE-FLOAT" "DESCEND-INTO"
	   "DIVISION-BY-ZERO-ERROR"
	   "DOUBLE-FLOAT-EXPONENT"
	   "DOUBLE-FLOAT-BITS"
	   "DOUBLE-FLOAT-HIGH-BITS"
	   "DOUBLE-FLOAT-INT-EXPONENT"
	   "DOUBLE-FLOAT-LOW-BITS" "DOUBLE-FLOAT-P" "FLOAT-WAIT"
	   "DYNAMIC-SPACE-FREE-POINTER" "ERROR-NUMBER-OR-LOSE" "FILENAME"
	   "FLOAT-DIGITS" "FLOAT-EXPONENT" "FLOAT-FORMAT-DIGITS"
	   "FLOAT-FORMAT-MAX" "FLOAT-INT-EXPONENT" "FLOAT-RADIX" "FORM" "FUNCALLABLE-INSTANCE-P"
	   "FUNCTION-CODE-HEADER" "FUNCTION-TYPE" "FUNCTION-TYPE-ALLOWP"
	   "FUNCTION-TYPE-KEYP" "FUNCTION-TYPE-KEYWORDS"
	   "FUNCTION-TYPE-NARGS" "FUNCTION-TYPE-OPTIONAL" "FUNCTION-TYPE-P"
	   "FUNCTION-TYPE-REQUIRED" "FUNCTION-TYPE-REST"
	   "FUNCTION-TYPE-RETURNS" "FUNCTION-TYPE-WILD-ARGS"
	   "FUNCTION-WORD-OFFSET" "GET-CLOSURE-LENGTH" "GET-HEADER-DATA"
	   "GET-LISP-OBJ-ADDRESS" "GET-LOWTAG" "GET-TYPE" "HAIRY-TYPE"
	   "HAIRY-TYPE-CHECK-TEMPLATE" "HAIRY-TYPE-SPECIFIER"
	   "NEGATION-TYPE" "NEGATION-TYPE-TYPE"
	   "INTERSECTION-TYPE" "INTERSECTION-TYPE-TYPES"
	   "HANDLE-CIRCULARITY" "INDEX" "INIT-RANDOM-STATE" "INTEGER-DECODE-DOUBLE-FLOAT"
	   "INTEGER-DECODE-LONG-FLOAT" "INTEGER-DECODE-SINGLE-FLOAT"
	   "INTERNAL-TIME"
	   "INVALID-ARGUMENT-COUNT-ERROR" "INVALID-ARRAY-INDEX-ERROR"
	   "INVALID-UNWIND-ERROR" "IRRATIONAL" "KEY-INFO" "KEY-INFO-NAME"
	   "KEY-INFO-P" "KEY-INFO-TYPE"
	   "LAYOUT-INVALID-ERROR" "LEXICAL-ENVIRONMENT"
	   "LONG-FLOAT-EXPONENT" "LONG-FLOAT-EXP-BITS" "LONG-FLOAT-HIGH-BITS"
	   "LONG-FLOAT-LOW-BITS" "LONG-FLOAT-MID-BITS" "LONG-FLOAT-P"
	   "LRA" "LRA-CODE-HEADER" "LRA-P"
	   "MAKE-ALIEN-TYPE-TYPE" "MAKE-ARGS-TYPE"
	   "MAKE-ARRAY-HEADER"  "MAKE-CONS-TYPE"
	   "MAKE-DOUBLE-FLOAT" "MAKE-FUNCTION-TYPE"
	   "MAKE-KEY-INFO" "MAKE-LISP-OBJ" "MAKE-LONG-FLOAT"
	   "MAKE-MEMBER-TYPE"
	   "MAKE-NAMED-TYPE" "MAKE-NUMERIC-TYPE" "MAKE-SINGLE-FLOAT"
	   "%MAKE-INSTANCE" "MAKE-UNION-TYPE"
	   "MAKE-VALUES-TYPE" "MEMBER-TYPE" "MEMBER-TYPE-MEMBERS"
	   "MEMBER-TYPE-P" "MERGE-BITS" "MUTATOR-SELF" "NAMED-TYPE"
	   "NAMED-TYPE-NAME" "NAMED-TYPE-P" "NATIVE-BYTE-ORDER" "NEGATE"
	   "NEVER-SUBTYPEP" "NIL-FUNCTION-RETURNED-ERROR" "NOT-<=-ERROR"
	   "NOT-=-ERROR" "NUMERIC-CONTAGION" "NUMERIC-TYPE"
	   "NUMERIC-TYPE-CLASS" "NUMERIC-TYPE-COMPLEXP" "NUMERIC-TYPE-FORMAT"
	   "NUMERIC-TYPE-HIGH" "NUMERIC-TYPE-LOW" "NUMERIC-TYPE-P"
	   "OBJECT-NOT-ARRAY-ERROR" "OBJECT-NOT-BASE-CHAR-ERROR"
	   "OBJECT-NOT-BIGNUM-ERROR" "OBJECT-NOT-BIT-VECTOR-ERROR"
	   "OBJECT-NOT-COERCABLE-TO-FUNCTION-ERROR"
	   "OBJECT-NOT-COMPLEX-ERROR" "OBJECT-NOT-COMPLEX-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-SINGLE-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-DOUBLE-FLOAT-ERROR"
	   "OBJECT-NOT-COMPLEX-RATIONAL-ERROR" "OBJECT-NOT-CONS-ERROR"
	   "OBJECT-NOT-DOUBLE-FLOAT-ERROR" "OBJECT-NOT-FIXNUM-ERROR"
	   "OBJECT-NOT-FLOAT-ERROR" "OBJECT-NOT-FUNCTION-ERROR"
	   "OBJECT-NOT-FUNCTION-OR-SYMBOL-ERROR" "OBJECT-NOT-INSTANCE-ERROR"
	   "OBJECT-NOT-INTEGER-ERROR"
	   "OBJECT-NOT-LIST-ERROR" "OBJECT-NOT-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-NUMBER-ERROR"
	   "OBJECT-NOT-RATIO-ERROR" "OBJECT-NOT-RATIONAL-ERROR"
	   "OBJECT-NOT-REAL-ERROR" "OBJECT-NOT-SAP-ERROR"
	   "OBJECT-NOT-SIGNED-BYTE-32-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-COMPLEX-DOUBLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-COMPLEX-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-COMPLEX-SINGLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-DOUBLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-LONG-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-SINGLE-FLOAT-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-16-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-2-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-32-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-4-ERROR"
	   "OBJECT-NOT-SIMPLE-ARRAY-UNSIGNED-BYTE-8-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-16-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-30-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-32-ERROR"
 	   "OBJECT-NOT-SIMPLE-ARRAY-SIGNED-BYTE-8-ERROR"
	   "OBJECT-NOT-SIMPLE-BIT-VECTOR-ERROR"
	   "OBJECT-NOT-SIMPLE-STRING-ERROR" "OBJECT-NOT-SIMPLE-VECTOR-ERROR"
	   "OBJECT-NOT-SINGLE-FLOAT-ERROR" "OBJECT-NOT-STRING-ERROR"
	   "OBJECT-NOT-INSTANCE-ERROR" "OBJECT-NOT-SYMBOL-ERROR"
	   "OBJECT-NOT-TYPE-ERROR" "OBJECT-NOT-UNSIGNED-BYTE-32-ERROR"
	   "OBJECT-NOT-VECTOR-ERROR" "OBJECT-NOT-WEAK-POINTER-ERROR"
	   "ODD-KEYWORD-ARGUMENTS-ERROR" "ORDER-LAYOUT-INHERITS"
	   "OUTPUT-OBJECT" "OUTPUT-UGLY-OBJECT"
	   "PARSE-LAMBDA-LIST" "PARSE-UNKNOWN-TYPE"
	   "PARSE-UNKNOWN-TYPE-SPECIFIER" "PATHNAME-DEVICE"
	   "PATHNAME-DIRECTORY" "PATHNAME-HOST" "PATHNAME-NAME"
	   "PATHNAME-TYPE" "PATHNAME-VERSION" "PATHNAMELIKE" "PUNT-IF-TOO-LONG"
	   "SCALE-DOUBLE-FLOAT" "SCALE-LONG-FLOAT" "SCALE-SINGLE-FLOAT"
	   "SEQUENCE-END" "SET-HEADER-DATA" "SHIFT-TOWARDS-END"
	   "SHIFT-TOWARDS-START" "SIGNAL-INIT" "SIGNED-BYTE-32-P"
	   "SIMPLE-ARRAY-COMPLEX-DOUBLE-FLOAT-P"
	   "SIMPLE-ARRAY-COMPLEX-LONG-FLOAT-P"
	   "SIMPLE-ARRAY-COMPLEX-SINGLE-FLOAT-P"
	   "SIMPLE-ARRAY-DOUBLE-FLOAT-P" "SIMPLE-ARRAY-LONG-FLOAT-P"
	   "SIMPLE-ARRAY-P"
	   "SIMPLE-ARRAY-SINGLE-FLOAT-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-16-P"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-2-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-32-P"
	   "SIMPLE-ARRAY-UNSIGNED-BYTE-4-P" "SIMPLE-ARRAY-UNSIGNED-BYTE-8-P"
 	   "SIMPLE-ARRAY-SIGNED-BYTE-16-P" "SIMPLE-ARRAY-SIGNED-BYTE-30-P"
	   "SIMPLE-ARRAY-SIGNED-BYTE-32-P" "SIMPLE-ARRAY-SIGNED-BYTE-8-P" 
	   "SIMPLE-UNBOXED-ARRAY" "SINGLE-FLOAT-BITS" "SINGLE-FLOAT-EXPONENT"
	   "SINGLE-FLOAT-INT-EXPONENT"
	   "SINGLE-FLOAT-P" "SINGLE-VALUE-TYPE" "SPECIFIER-TYPE" "STACK-REF"
	   "STD-COMPUTE-CLASS-PRECEDENCE-LIST"
	   "STREAMLIKE" "SIMPLE-STREAM-BUFFER" "STRINGABLE" "STRINGLIKE"
	   "%INSTANCE-LENGTH"
	   "%INSTANCE-REF" "%INSTANCE-SET"
	   "SYSTEM-AREA-CLEAR"
	   "SYSTEM-AREA-COPY" "TRUTH" "TWO-ARG-*" "TWO-ARG-+" "TWO-ARG--"
	   "TWO-ARG-/" "TWO-ARG-/=" "TWO-ARG-<" "TWO-ARG-<=" "TWO-ARG-="
	   "TWO-ARG->" "TWO-ARG->=" "TWO-ARG-AND" "TWO-ARG-GCD" "TWO-ARG-IOR"
	   "TWO-ARG-LCM" "TWO-ARG-XOR" "TYPE-DIFFERENCE" "TYPE-EXPAND"
	   "TYPE-INIT" "TYPE-INTERSECT" "TYPE-INTERSECTION" "TYPE-SPECIFIER"
	   "TYPE-SPECIFIER-SYMBOLS" "TYPE-UNION" "TYPE/=" "TYPE="
	   "TYPES-INTERSECT" "UNBOUND-SYMBOL-ERROR" "UNBOXED-ARRAY"
	   "UNDEFINED-SYMBOL-ERROR" "UNDEFINED-FOREIGN-SYMBOL-ERROR"
           "UNDEFINED-FOREIGN-SYMBOL-ERROR-HANDLER"
	   "UNION-TYPE" "UNION-TYPE-P"
	   "UNION-TYPE-TYPES" "UNKNOWN-ERROR"
	   "UNKNOWN-KEYWORD-ARGUMENT-ERROR" "UNKNOWN-TYPE" "UNKNOWN-TYPE-P"
	   "UNKNOWN-TYPE-SPECIFIER" "UNSEEN-THROW-TAG-ERROR"
	   "UNSIGNED-BYTE-32-P" "VALUES-SPECIFIER-TYPE"
	   "VALUES-SPECIFIER-TYPE-CACHE-CLEAR" "VALUES-SUBTYPEP"
	   "VALUES-TYPE" "VALUES-TYPE-ALLOWP" "VALUES-TYPE-INTERSECT"
	   "VALUES-TYPE-INTERSECTION" "VALUES-TYPE-KEYP"
	   "VALUES-TYPE-KEYWORDS" "VALUES-TYPE-OPTIONAL" "VALUES-TYPE-P"
	   "VALUES-TYPE-REQUIRED" "VALUES-TYPE-REST" "VALUES-TYPE-UNION"
	   "VALUES-TYPES" "VALUES-TYPES-INTERSECT" "VOID"
	   "WITH-CIRCULARITY-DETECTION" "WRONG-NUMBER-OF-INDICES-ERROR"
	   "FDEFN" "MAKE-FDEFN" "FDEFN-P" "FDEFN-NAME" "FDEFN-FUNCTION"
	   "FDEFN-OR-LOSE"
	   "FDEFN-MAKUNBOUND" "%COERCE-TO-FUNCTION" "FUNCTION-SUBTYPE"
	   "*MAXIMUM-ERROR-DEPTH*" "%SET-SYMBOL-PLIST"
	   "INFINITE-ERROR-PROTECT"
	   "FIND-CALLER-NAME" "OLD-IN-PACKAGE"
	   "%SET-SYMBOL-VALUE" "%SET-SYMBOL-PACKAGE" "OUTPUT-SYMBOL-NAME"
	   "FSET" "RAW-DEFINITION" "%IN-PACKAGE" "%DEFPACKAGE"
	   "INVOKE-MACROEXPAND-HOOK" "TYPEDEF-INIT" "DEFAULT-STRUCTURE-PRINT"
	   "LAYOUT" "LAYOUT-LENGTH" "RATIOP" "FIXNUMP"
	   "LAMBDA-WITH-ENVIRONMENT" "LAYOUT-PURE" "DSD-RAW-TYPE"
	   "%COMPILER-DEFSTRUCT" "DEFSTRUCT-DESCRIPTION" "UNDEFINE-STRUCTURE"
	   "BIGNUMP" "DD-COPIER" "UNDEFINE-FUNCTION-NAME" "DD-TYPE"
	   "CLASS-STATE" "INSTANCE"
	   "*TYPE-SYSTEM-INITIALIZED*" "WEAK-POINTER-P" "FIND-LAYOUT"
	   "DSD-NAME" "%TYPEP" "DD-RAW-INDEX" "DD-NAME" "CLASS-SUBCLASSES"
	   "CLASS-LAYOUT"
	   "DD-RAW-LENGTH" "NOTE-NAME-DEFINED"
	   "%CODE-CODE-SIZE" "DD-SLOTS" "%IMAGPART" "DSD-ACCESSOR" "CLASS-INIT"
	   "%CODE-DEBUG-INFO" "DSD-%NAME" "LAYOUT-CLASS" "LAYOUT-INVALID"
	   "%FUNCTION-NAME" "DSD-TYPE" "%INSTANCEP"
	   "DEFSTRUCT-SLOT-DESCRIPTION"
	   "MAKE-STRUCTURE-LOAD-FORM" "BITP" "%FUNCTION-ARGLIST"
	   "%FUNCTION-NEXT" "LAYOUT-HASH-LENGTH" "DD-PREDICATE"
	   "CLASS-PROPER-NAME" "%NOTE-TYPE-DEFINED" "LAYOUT-INFO"
	   "%SET-INSTANCE-LAYOUT" "DD-DEFAULT-CONSTRUCTOR" "LAYOUT-OF"
	   "%FUNCTION-SELF" "%REALPART" "STRUCTURE-CLASS-P" "DSD-INDEX"
	   "%INSTANCE-LAYOUT" "LAYOUT-HASH" "%FUNCTION-TYPE"
	   "DEFINE-FUNCTION-NAME" "LAYOUT-INHERITANCE-DEPTH"
	   "%%COMPILER-DEFSTRUCT" "%NUMERATOR" "CLASS-TYPEP"
	   "STRUCTURE-CLASS-PRINT-FUNCTION" "DSD-READ-ONLY" "LAYOUT-INHERITS"
	   "DD-LENGTH" "%CODE-ENTRY-POINTS"
	   "STRUCTURE-CLASS-MAKE-LOAD-FORM-FUN" "%DENOMINATOR"
	   "BYTE-FUNCTION-OR-CLOSURE" "MAKE-STANDARD-CLASS"
	   "BYTE-FUNCTION-NAME" "CLASS-CELL-TYPEP" "BYTE-CLOSURE"
	   "FIND-CLASS-CELL" "EXTRACT-FUNCTION-TYPE"
	   "FUNCALLABLE-STRUCTURE-CLASS"
	   "%RANDOM-DOUBLE-FLOAT" "%RANDOM-LONG-FLOAT" "%RANDOM-SINGLE-FLOAT" 
	   "RANDOM-PCL-CLASS" "BASIC-STRUCTURE-CLASS-PRINT-FUNCTION"
	   "%FUNCALLABLE-INSTANCE-INFO" "*EVAL-STACK*" "RANDOM-CHUNK"
	   "MAKE-FUNCALLABLE-STRUCTURE-CLASS" "LAYOUT-HASH-MAX"
	   "CLASS-CELL-NAME" "BUILT-IN-CLASS-DIRECT-SUPERCLASSES"
	   "INITIALIZE-BYTE-COMPILED-FUNCTION" "INITIALIZE-LAYOUT-HASH"
	   "CLASS-PCL-CLASS" "FUNCALLABLE-STRUCTURE"
	   "FUNCALLABLE-INSTANCE-FUNCTION" "%FUNCALLABLE-INSTANCE-LAYOUT"
	   "BASIC-STRUCTURE-CLASS" "BYTE-CLOSURE-DATA"
	   "BYTE-CLOSURE-FUNCTION" "BYTE-FUNCTION" "CLASS-CELL-CLASS"
	   "FUNCALLABLE-STRUCTURE-CLASS-P" "REGISTER-LAYOUT"
	   "FUNCALLABLE-INSTANCE" "RANDOM-FIXNUM-MAX" "MAKE-RANDOM-PCL-CLASS"
	   "INSTANCE-LAMBDA" "%FUNCALLABLE-INSTANCE-LEXENV" "%MAKE-SYMBOL"
	   "%FUNCALLABLE-INSTANCE-FUNCTION" "SYMBOL-HASH"

	   "MAKE-UNDEFINED-CLASS" "%COMPILER-ONLY-DEFSTRUCT"
	   "CLASS-DIRECT-SUPERCLASSES" "MAKE-LAYOUT" "SIMPLE-CONTROL-ERROR"
	   "SIMPLE-FILE-ERROR" "SIMPLE-PROGRAM-ERROR" "SIMPLE-STYLE-WARNING"
	   "SIMPLE-UNDEFINED-FUNCTION" "SIMPLE-PARSE-ERROR" "SIMPLE-STREAM-ERROR"
	   "BYTE-FUNCTION-TYPE" "SLOT-CLASS-PRINT-FUNCTION"
	   "REDEFINE-LAYOUT-WARNING" "SLOT-CLASS" "INSURED-FIND-CLASS"
	   "CONDITION-FUNCTION-NAME"

	   "%COMPLEX-SINGLE-FLOAT"
	   "%COMPLEX-DOUBLE-FLOAT"
	   "%COMPLEX-DOUBLE-DOUBLE-FLOAT"
	   "STANDARD-READTABLE-MODIFIED-ERROR"
	   "STANDARD-PPRINT-DISPATCH-TABLE-MODIFIED-ERROR"

	   "%IEEE754-REM-PI/2"
	   "%SINCOS")
  #+heap-overflow-check
  (:export "DYNAMIC-SPACE-OVERFLOW-WARNING-HIT"
	   "DYNAMIC-SPACE-OVERFLOW-ERROR-HIT"
	   "HEAP-OVERFLOW")
  #+X86
  (:export "ATOMIC-PUSH-VECTOR" "RPLACD-CONDITIONAL"
           "ATOMIC-PUSH-SYMBOL-VALUE"
           "DATA-VECTOR-SET-CONDITIONAL"
           "RPLACA-CONDITIONAL"
           "%INSTANCE-SET-CONDITIONAL"
           "SET-SYMBOL-VALUE-CONDITIONAL"
           "ATOMIC-POP-SYMBOL-VALUE"
           "ATOMIC-PUSHA"
           "ATOMIC-PUSHD"
	   "%UNARY-FROUND")
  #+x87
  (:export "%COS-QUICK" "%SIN-QUICK" "%TAN-QUICK")
  ;;#+double-double
  (:export "DOUBLE-DOUBLE-FLOAT"
	   "DOUBLE-DOUBLE-FLOAT-P"
	   "DOUBLE-DOUBLE-HI"
	   "DOUBLE-DOUBLE-LO"
	   "MAKE-DOUBLE-DOUBLE-FLOAT"
	   "%MAKE-DOUBLE-DOUBLE-FLOAT"
	   "%DOUBLE-DOUBLE-FLOAT"
	   "OBJECT-NOT-DOUBLE-DOUBLE-FLOAT-ERROR"
	   "SIMPLE-ARRAY-DOUBLE-DOUBLE-FLOAT-P"
	   "OBJECT-NOT-SIMPLE-ARRAY-DOUBLE-DOUBLE-FLOAT-ERROR"
	   "COMPLEX-DOUBLE-DOUBLE-FLOAT-P"
	   "OBJECT-NOT-COMPLEX-DOUBLE-DOUBLE-FLOAT-ERROR"

	   "SIMPLE-ARRAY-COMPLEX-DOUBLE-DOUBLE-FLOAT-P"
	   "OBJECT-NOT-SIMPLE-ARRAY-COMPLEX-DOUBLE-DOUBLE-FLOAT-ERROR"
	   "DD-PI"
	   "INVALID-CASE")
  #+random-xoroshiro
  (:export "RANDOM-STATE-JUMP"))

(dolist
    (name
     '("BRANCH" "FLUSHABLE" "SSET-ELEMENT" "SSET" "MAKE-SSET"
       "DO-ELEMENTS" "SSET-ADJOIN" "SSET-DELETE" "SSET-EMPTY"))
  (intern name "C"))

(defpackage "NEW-ASSEM"
  (:import-from "C" "BRANCH" "FLUSHABLE" "SSET-ELEMENT" "SSET" "MAKE-SSET"
		"DO-ELEMENTS" "SSET-ADJOIN" "SSET-DELETE" "SSET-EMPTY")
  (:export "EMIT-BYTE" "EMIT-SKIP" "EMIT-BACK-PATCH" "EMIT-CHOOSER"
	   "DEFINE-EMITTER" "DEFINE-INSTRUCTION" "DEFINE-INSTRUCTION-MACRO"
	   "DEF-ASSEMBLER-PARAMS" "EMIT-POSTIT"

	   "MAKE-SEGMENT" "SEGMENT-NAME" "ASSEMBLE" "ALIGN" "INST"
	   "LABEL" "LABEL-P" "GEN-LABEL" "EMIT-LABEL" "LABEL-POSITION"
	   "APPEND-SEGMENT" "FINALIZE-SEGMENT"
	   "SEGMENT-MAP-OUTPUT" "RELEASE-SEGMENT"
	   "READS" "WRITES" "SEGMENT"
	   "WITHOUT-SCHEDULING" "BRANCH" "FLUSHABLE" "VARIABLE-LENGTH"
	   "SEGMENT-COLLECT-DYNAMIC-STATISTICS"))

(defpackage "MULTIPROCESSING"
  (:use "COMMON-LISP")
  (:nicknames "MP")
  (:export "*ALL-PROCESSES*" "*CURRENT-PROCESS*" "*CURRENT-STACK-GROUP*"
	   "*INITIAL-STACK-GROUP*" "*MULTI-PROCESSING*"
	   "ALL-PROCESSES" "ATOMIC-DECF" "ATOMIC-INCF" "ATOMIC-POP"
	   "ATOMIC-PUSH" "CURRENT-PROCESS" "DESTROY-PROCESS" "DISABLE-PROCESS"
	   "ENABLE-PROCESS" "INIT-STACK-GROUPS" "LOCK" "MAKE-STACK-GROUP"
	   "MAKE-LOCK" "MAKE-PROCESS" "PROCESS-ACTIVE-P"
	   "PROCESS-JOIN"
	   "PROCESS-ADD-ARREST-REASON" "PROCESS-ADD-RUN-REASON"
	   "PROCESS-ALIVE-P" "PROCESS-ARREST-REASONS"
	   "PROCESS-IDLE-TIME" "PROCESS-INTERRUPT" "PROCESS-NAME"
	   "PROCESS-PRESET" "PROCESS-PROPERTY-LIST"
	   "PROCESS-REAL-TIME" "PROCESS-REVOKE-ARREST-REASON"
	   "PROCESS-REVOKE-RUN-REASON" "PROCESS-RUN-REASONS" "PROCESS-RUN-TIME"
	   "PROCESS-STATE" "PROCESS-WAIT-UNTIL-FD-USABLE"
	   "PROCESS-WAIT" "PROCESS-WAIT-WITH-TIMEOUT" 
	   "PROCESS-WHOSTATE" "PROCESS-YIELD" "PROCESSP" "RESTART-PROCESS" 
	   "SHOW-PROCESSES" "STACK-GROUP-RESUME" "WITHOUT-SCHEDULING"
	   "WITH-LOCK-HELD" "WITH-TIMEOUT"))

(defpackage "WALKER"
  (:use "COMMON-LISP" "EXT")
  (:export "DEFINE-WALKER-TEMPLATE"
	   "WALK-FORM"
	   "WALK-FORM-EXPAND-MACROS-P"
	   "NESTED-WALK-FORM"
	   "VARIABLE-LEXICAL-P"
	   "VARIABLE-SPECIAL-P"
	   "VARIABLE-GLOBALLY-SPECIAL-P"
	   "*VARIABLE-DECLARATIONS*"
	   "VARIABLE-DECLARATION"
	   "MACROEXPAND-ALL"))

(defpackage "FWRAPPERS"
  (:use "COMMON-LISP" "EXT" "KERNEL")
  (:export "DEFINE-FWRAPPER"
	   "FWRAPPER"
	   "CALL-NEXT-FUNCTION"
	   "FWRAP"
	   "FUNWRAP"
	   "FIND-FWRAPPER"
	   "FWRAPPER-TYPE" "FWRAPPER-NEXT" "FWRAPPER-USER-DATA"
	   "FWRAPPER-CONSTRUCTOR"
	   "UPDATE-FWRAPPER" "UPDATE-FWRAPPERS"
	   "SET-FWRAPPERS"
	   "LIST-FWRAPPERS"
	   "PUSH-FWRAPPER"
	   "DELETE-FWRAPPER"
	   "LAST-FWRAPPER"
	   "DO-FWRAPPERS"))

(defpackage "UNICODE"
  (:use "COMMON-LISP")
  (:shadow "STRING-CAPITALIZE"
	   "STRING-DOWNCASE"
	   "STRING-UPCASE")
  (:import-from "LISP"
		"CODEPOINT"
		"SURROGATES"
		"UNICODE-FULL-CASE-LOWER"
		"UNICODE-FULL-CASE-UPPER"
		"UNICODE-FULL-CASE-TITLE"
		"UNICODE-CATEGORY"
		"+UNICODE-CATEGORY-LOWER+"
		"+UNICODE-CATEGORY-OTHER+"
		"+UNICODE-CATEGORY-GRAPHIC+"
		"+UNICODE-CATEGORY-UPPER+"
		"+UNICODE-CATEGORY-TITLE+"
		"UNICODE-UPPER"
		"UNICODE-WORD-BREAK")
  (:export "STRING-CAPITALIZE"
	   "STRING-DOWNCASE"
	   "STRING-UPCASE"
	   "STRING-NEXT-WORD-BREAK"))


