;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: STREAM -*-
;;;
;;; **********************************************************************
;;; This code was written by Paul Foley and has been placed in the public
;;; domain.
;;;
(ext:file-comment "$Header: /project/cmucl/cvsroot/src/pcl/simple-streams/external-formats/beta-gk.lisp,v 1.2 2009-06-11 16:04:02 rtoy Exp $")

;; This is a composing format that translates (lower-case) Beta code
;; (an ASCII encoding of ancient Greek) into Unicode Greek.

(defvar *betamap*
  '((109 956)
    ((102 966)
     ((98 946)
      ((58 183)
       ((42 42 (108 923)
         ((100 916)
          ((92 8175 (105 8154) ((101 8136) ((97 8122)) ((104 8138)))
            ((117 8170) ((111 8184)) ((119 8186))))
           ((41 8127 (101 7960)
             ((92 8141 (105 7994)
               ((101 7962) ((97 7946 (124 8074))) ((104 7978 (124 8090))))
               ((119 8042 (124 8106)) ((111 8010)) NIL))
              ((61 8143 (105 7998)
                ((104 7982 (124 8094)) ((97 7950 (124 8078))) NIL)
                ((119 8046 (124 8110))))
               ((47 8142 (105 7996)
                 ((101 7964) ((97 7948 (124 8076))) ((104 7980 (124 8092))))
                 ((119 8044 (124 8108)) ((111 8012)) NIL)))
               NIL)
              ((97 7944 (124 8072))))
             ((111 8008) ((105 7992) ((104 7976 (124 8088))) NIL)
              ((119 8040 (124 8104)))))
            ((40 8190 (104 7977 (124 8089))
              ((92 8157 (105 7995)
                ((101 7963) ((97 7947 (124 8075))) ((104 7979 (124 8091))))
                ((117 8027) ((111 8011)) ((119 8043 (124 8107)))))
               ((61 8159 (105 7999)
                 ((104 7983 (124 8095)) ((97 7951 (124 8079))) NIL)
                 ((119 8047 (124 8110)) ((117 8031)) NIL))
                ((47 8158 (105 7997)
                  ((101 7965) ((97 7949 (124 8077))) ((104 7981 (124 8093))))
                  ((117 8029) ((111 8013)) ((119 8045 (124 8109))))))
                NIL)
               ((101 7961) ((97 7945 (124 8073))) NIL))
              ((114 8172) ((111 8009) ((105 7993)) NIL)
               ((119 8041 (124 8105)) ((117 8025)) NIL))))
            ((47 8189 (105 8155) ((101 8137) ((97 8123)) ((104 8139)))
              ((117 8171) ((111 8185)) ((119 8187))))))
           ((98 914) ((97 913 (124 8124))) ((99 926))))
          ((104 919 (124 8140)) ((102 934) ((101 917)) ((103 915)))
           ((107 922) ((105 921 (43 938))) NIL)))
         ((116 932)
          ((112 928) ((110 925) ((109 924)) ((111 927)))
           ((114 929) ((113 920)) ((115 931))))
          ((120 935) ((118 988) ((117 933 (43 939))) ((119 937 (124 8188))))
           ((122 918) ((121 936)) NIL)))))
       ((97 945 (61 8118 (124 8119))
         ((41 7936 (92 7938 (124 8066))
           ((61 7942 (124 8070)) ((47 7940 (124 8068))) NIL) ((124 8064)))
          ((40 7937 (92 7939 (124 8067))
            ((61 7943 (124 8071)) ((47 7941 (124 8069))) NIL) ((124 8065))))
          ((47 8049 (124 8116))))
         ((124 8115) ((92 8048 (124 8114))) NIL))))
      ((100 948) ((99 958))
       ((101 949 (47 8051)
         ((41 7952 (92 7954) ((47 7956)) NIL)
          ((40 7953 (92 7955) ((47 7957)) NIL)) NIL)
         ((92 8050))))))
     ((106 962)
      ((104 951 (61 8134 (124 8135))
        ((41 7968 (92 7970 (124 8082))
          ((61 7974 (124 8086)) ((47 7972 (124 8084))) NIL) ((124 8080)))
         ((40 7969 (92 7971 (124 8083))
           ((61 7975 (124 8087)) ((47 7973 (124 8085))) NIL) ((124 8081))))
         ((47 8053 (124 8132))))
        ((124 8131) ((92 8052 (124 8130))) NIL))
       ((103 947))
       ((105 953 (47 8055 (43 8147))
         ((41 7984 (61 7990) ((47 7988)) ((92 7986)))
          ((40 7985 (61 7991) ((47 7989)) ((92 7987)))) ((43 970)))
         ((92 8054 (43 8146)) ((61 8150 (43 8151))) NIL))))
      ((108 955) ((107 954)) NIL)))
    ((116 964)
     ((113 952)
      ((111 959 (47 8057)
        ((41 8000 (92 8002) ((47 8004)) NIL)
         ((40 8001 (92 8003) ((47 8005)) NIL)) NIL)
        ((92 8056)))
       ((110 957)) ((112 960)))
      ((115 963) ((114 961 (41 8164) ((40 8165)) NIL)) NIL))
     ((120 967)
      ((118 989)
       ((117 965 (47 8059 (43 8163))
         ((41 8016 (61 8022) ((47 8020)) ((92 8018)))
          ((40 8017 (61 8023) ((47 8021)) ((92 8019)))) ((43 971)))
         ((92 8058 (43 8162)) ((61 8166 (43 8167))) NIL)))
       ((119 969 (61 8182 (124 8183))
         ((41 8032 (92 8034 (124 8098))
           ((61 8038 (124 8102)) ((47 8036 (124 8100))) NIL) ((124 8096)))
          ((40 8033 (92 8035 (124 8099))
            ((61 8039 (124 8103)) ((47 8037 (124 8101))) NIL) ((124 8097))))
          ((47 8061 (124 8180))))
         ((124 8179) ((92 8060 (124 8178))) NIL))))
      ((122 950) ((121 968)) NIL)))))

(defvar *betamap-rev*
  '(((8064 . 47)
     . #(#(97 41 124) #(97 40 124) #(97 41 92 124) #(97 40 92 124)
         #(97 41 47 124) #(97 40 47 124) #(97 41 61 124) #(97 40 61 124)
         #(42 41 97 124) #(42 40 97 124) #(42 41 92 97 124) #(42 40 92 97 124)
         #(42 41 47 97 124) #(42 40 47 97 124) #(42 41 61 97 124)
         #(42 40 61 97 124) #(104 41 124) #(104 40 124) #(104 41 92 124)
         #(104 40 92 124) #(104 41 47 124) #(104 40 47 124) #(104 41 61 124)
         #(104 40 61 124) #(42 41 104 124) #(42 40 104 124) #(42 41 92 104 124)
         #(42 40 92 104 124) #(42 41 47 104 124) #(42 40 47 104 124)
         #(42 41 61 104 124) #(42 40 61 104 124) #(119 41 124) #(119 40 124)
         #(119 41 92 124) #(119 40 92 124) #(119 41 47 124) #(119 40 47 124)
         #(119 41 61 124) #(119 40 61 124) #(42 41 119 124) #(42 40 119 124)
         #(42 41 92 119 124) #(42 40 92 119 124) #(42 41 47 119 124)
         #(42 40 47 119 124) #(42 40 61 119 124)))
    (((7936 . 22)
      . #(#(97 41) #(97 40) #(97 41 92) #(97 40 92) #(97 41 47) #(97 40 47)
          #(97 41 61) #(97 40 61) #(42 41 97) #(42 40 97) #(42 41 92 97)
          #(42 40 92 97) #(42 41 47 97) #(42 40 47 97) #(42 41 61 97)
          #(42 40 61 97) #(101 41) #(101 40) #(101 41 92) #(101 40 92)
          #(101 41 47) #(101 40 47)))
     (((945 . 27)
       . #(#(97) #(98) #(103) #(100) #(101) #(122) #(104) #(113) #(105) #(107)
           #(108) #(109) #(110) #(99) #(111) #(112) #(114) #(106) #(115) #(116)
           #(117) #(102) #(120) #(121) #(119) #(105 43) #(117 43)))
      (((913 . 27)
        . #(#(42 97) #(42 98) #(42 103) #(42 100) #(42 101) #(42 122) #(42 104)
            #(42 113) #(42 105) #(42 107) #(42 108) #(42 109) #(42 110)
            #(42 99) #(42 111) #(42 112) #(42 114) NIL #(42 115) #(42 116)
            #(42 117) #(42 102) #(42 120) #(42 121) #(42 119) #(42 105 43)
            #(42 117 43)))
       ((183 . #(58))) NIL)
      (((988 . 2) . #(#(42 118) #(118)))))
     (((8008 . 6)
       . #(#(42 41 111) #(42 40 111) #(42 41 92 111) #(42 40 92 111)
           #(42 41 47 111) #(42 40 47 111)))
      (((7968 . 38)
        . #(#(104 41) #(104 40) #(104 41 92) #(104 40 92) #(104 41 47)
            #(104 40 47) #(104 41 61) #(104 40 61) #(42 41 104) #(42 40 104)
            #(42 41 92 104) #(42 40 92 104) #(42 41 47 104) #(42 40 47 104)
            #(42 41 61 104) #(42 40 61 104) #(105 41) #(105 40) #(105 41 92)
            #(105 40 92) #(105 41 47) #(105 40 47) #(105 41 61) #(105 40 61)
            #(42 41 105) #(42 40 105) #(42 41 92 105) #(42 40 92 105)
            #(42 41 47 105) #(42 40 47 105) #(42 41 61 105) #(42 40 61 105)
            #(111 41) #(111 40) #(111 41 92) #(111 40 92) #(111 41 47)
            #(111 40 47)))
       (((7960 . 6)
         . #(#(42 41 101) #(42 40 101) #(42 41 92 101) #(42 40 92 101)
             #(42 41 47 101) #(42 40 47 101))))
       NIL)
      (((8016 . 46)
        . #(#(117 41) #(117 40) #(117 41 92) #(117 40 92) #(117 41 47)
            #(117 40 47) #(117 41 61) #(117 40 61) NIL #(42 40 117) NIL
            #(42 40 92 117) NIL #(42 40 47 117) NIL #(42 40 61 117) #(119 41)
            #(119 40) #(119 41 92) #(119 40 92) #(119 41 47) #(119 40 47)
            #(119 41 61) #(119 40 61) #(42 41 119) #(42 40 119) #(42 41 92 119)
            #(42 40 92 119) #(42 41 47 119) #(42 40 47 119) #(42 41 61 119)
            #(42 40 61 119) #(97 92) #(97 47) #(101 92) #(101 47) #(104 92)
            #(104 47) #(105 92) #(105 47) #(111 92) #(111 47) #(117 92)
            #(117 47) #(119 92) #(119 47))))))
    (((8150 . 2) . #(#(105 61) #(105 61 43)))
     ((8127 . #(42 41))
      (((8122 . 3) . #(#(42 92 97) #(42 47 97) #(42 97 124)))
       (((8113 . 7)
         . #(#(97 95) #(97 92 124) #(97 124) #(97 47 124) NIL #(97 61)
             #(97 61 124))))
       NIL)
      (((8130 . 18)
        . #(#(104 92 124) #(104 124) #(104 47 124) NIL #(104 61) #(104 61 124)
            #(42 92 101) #(42 47 101) #(42 92 104) #(42 47 104) #(42 104 124)
            #(42 41 92) #(42 41 47) #(42 41 61) NIL #(105 95) #(105 92 43)
            #(105 47 43)))))
     ((8175 . #(42 92))
      (((8170 . 3) . #(#(42 92 117) #(42 47 117) #(42 40 114)))
       (((8154 . 14)
         . #(#(42 92 105) #(42 47 105) NIL #(42 40 92) #(42 40 47) #(42 40 61)
             NIL #(117 95) #(117 92 43) #(117 47 43) #(114 41) #(114 40)
             #(117 61) #(117 61 43))))
       NIL)
      (((8178 . 13)
        . #(#(119 92 124) #(119 124) #(119 47 124) NIL #(119 61) #(119 61 124)
            #(42 92 111) #(42 47 111) #(42 92 119) #(42 47 119) #(42 119 124)
            #(42 47) #(42 40))))))))


(define-composing-external-format :beta-gk (:min 1 :max 6) ; 6??
  (input (state input unput ch wd ent nch nwd nent)
    `(flet ((lookup (c map)
	      (loop while map do
		;; should work on upper case too
		(cond ((< c (caar map)) (setq map (cadr map)))
		      ((> c (caar map)) (setq map (caddr map)))
		      (t (return (car map)))))))
       (multiple-value-bind (,ch ,wd) ,input
	 (let ((,ent (and ,ch (lookup ,ch *betamap*))))
	   (if (null ,ent)
	       (values ,ch ,wd)
	       (loop
		 (unless (cddr ,ent) (return (values (cadr ,ent) ,wd)))
		 (multiple-value-bind (,nch ,nwd) ,input
		   (if (null ,nch)
		       (return (values (cadr ,ent) ,wd))
		       (let ((,nent (lookup ,nch (cddr ,ent))))
			 (if (null ,nent)
			     (progn (,unput ,nwd)
				    (return (values (cadr ,ent) ,wd)))
			     (setq ,wd (+ ,wd ,nwd)
				   ,ch ,nch
				   ,ent ,nent)))))))))))
  (output (code state output tmp rev)
    `(let ((,rev *betamap-rev*)
	   (,tmp nil))
       (loop while ,rev do
	 (if (consp (caar ,rev))
	     (cond ((< ,code (caaar ,rev)) (setq ,rev (cadr ,rev)))
		   ((>= ,code (+ (caaar ,rev) (cdaar ,rev)))
		    (setq ,rev (caddr ,rev)))
		   (t
		    (setq ,tmp (aref (cdar ,rev) (- ,code (caaar ,rev))))
		    (return)))
	     (cond ((< ,code (caar ,rev)) (setq ,rev (cadr ,rev)))
		   ((> ,code (caar ,rev)) (setq ,rev (caddr ,rev)))
		   (t
		    (setq ,tmp (cdar ,rev))
		    (return)))))
      (if ,tmp
	  (ext:dovector (tmp3 ,tmp) (,output tmp3))
	  (,output (if (> ,code 255) #x3F ,code))))))
