;;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;;
;;;; CMUCL 19c Patch 001a: Fix a bug in the pretty-printer for
;;;; MULTIPLE-VALUE-BIND, reported by Gareth McCaughan, cmucl-imp,
;;;; 2006-01-09.
;;;;
;;;; This supercedes cmucl-19c-patch-001 because the pushnew was in
;;;; the wrong place.
;;;;
;;;; (pprint '(multiple-value-bind 1)) causes an error.

(in-package "PP")

#+(and :cmu19c (not cmucl-19c-patch-001))
(ext:without-package-locks 
(defun pprint-multiple-value-bind (stream list &rest noise)
    (declare (ignore noise))
    (funcall (formatter "~:<~^~W~^~5I ~:_~W~^~3I ~:@_~W~1I~@{ ~:@_~W~}~:>")
	     stream list))
)

#+(and :cmu19c (not cmucl-19c-patch-001))
(set-pprint-dispatch `(cons (eql multiple-value-bind))
			   #'pprint-multiple-value-bind)

(pushnew :cmucl-19c-patch-001 *features*)

